/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.aliyun.ots.thirdparty.org.apache.http.impl.conn.SystemDefaultDnsResolver;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDnsResolver
extends SystemDefaultDnsResolver {
    private final Logger logger = LoggerFactory.getLogger(CachedDnsResolver.class);
    private static final int SCHEDULED_CORE_POOL_SIZE = 2;
    private final Cache<String, InetAddress[]> dnsCache;

    public CachedDnsResolver(int maxSize, int expireAfterWriteSec, int refreshAfterWriteSec) {
        RemovalListener<String, InetAddress[]> rmListener = new RemovalListener<String, InetAddress[]>(){

            public void onRemoval(RemovalNotification<String, InetAddress[]> notify) {
                if (CachedDnsResolver.this.logger.isDebugEnabled()) {
                    CachedDnsResolver.this.logger.debug("dns cache remove host key: {}, reason: {}", notify.getKey(), (Object)notify.getCause().name());
                }
            }
        };
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("refresh-dns-cache-" + thread.getId());
                return thread;
            }
        });
        this.dnsCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).weakKeys().expireAfterWrite((long)expireAfterWriteSec, TimeUnit.SECONDS).refreshAfterWrite((long)refreshAfterWriteSec, TimeUnit.SECONDS).removalListener((RemovalListener)rmListener).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, InetAddress[]>(){

            public InetAddress[] load(String host) throws Exception {
                if (CachedDnsResolver.this.logger.isDebugEnabled()) {
                    CachedDnsResolver.this.logger.debug("dns cache load, host: {}", (Object)host);
                }
                return CachedDnsResolver.super.resolve(host);
            }
        }, (Executor)scheduler));
    }

    public long cacheSize() {
        return this.dnsCache.size();
    }

    public CacheStats cacheStat() {
        return this.dnsCache.stats();
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] cached = (InetAddress[])this.dnsCache.getIfPresent((Object)host);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("dns resolve, host: {}, has cached: {}", (Object)host, (Object)(cached != null ? 1 : 0));
        }
        if (cached == null) {
            InetAddress[] realtime = super.resolve(host);
            if (realtime != null) {
                this.dnsCache.put((Object)host, (Object)realtime);
            }
            return realtime;
        }
        return cached;
    }

    public void clear() {
        this.dnsCache.cleanUp();
    }
}

