/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ResponseConsumer;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResponseFactory;
import com.alicloud.openservices.tablestore.core.protocol.ResultParser;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.List;

public class BulkImportResponseConsumer
extends ResponseConsumer<BulkImportResponse> {
    public BulkImportResponseConsumer(ResultParser resultParser, TraceLogger traceLogger, RetryStrategy retry, BulkImportResponse lastResult) {
        super(resultParser, traceLogger, retry, lastResult);
    }

    BulkImportResponse mergeResult(BulkImportResponse lastResult, BulkImportResponse result) {
        Response meta = new Response(result.getRequestId());
        meta.setTraceId(this.traceLogger.getTraceId());
        BulkImportResponse mergedResult = new BulkImportResponse(meta);
        List<BulkImportResponse.RowResult> lastRowResultList = lastResult.getRowResults();
        List<BulkImportResponse.RowResult> rowResultList = result.getRowResults();
        int idx = 0;
        for (BulkImportResponse.RowResult lastRowResult : lastRowResultList) {
            if (lastRowResult.isSucceed()) {
                mergedResult.addRowResult(lastRowResult);
                continue;
            }
            BulkImportResponse.RowResult rowResult = rowResultList.get(idx);
            ++idx;
            if (rowResult.isSucceed()) {
                mergedResult.addRowResult(new BulkImportResponse.RowResult(rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                continue;
            }
            mergedResult.addRowResult(new BulkImportResponse.RowResult(rowResult.getError(), lastRowResult.getIndex()));
        }
        return mergedResult;
    }

    @Override
    protected BulkImportResponse parseResult() throws Exception {
        List<BulkImportResponse.RowResult> failedRows;
        ResponseContentWithMeta responseContent = this.getResponseContentWithMeta();
        OtsInternalApi.BulkImportResponse bulkImportResponse = (OtsInternalApi.BulkImportResponse)responseContent.getMessage();
        BulkImportResponse result = ResponseFactory.createBulkImportResponse(responseContent, bulkImportResponse);
        if (this.lastResult != null) {
            result = this.mergeResult((BulkImportResponse)this.lastResult, result);
        }
        if ((failedRows = result.getFailedRows()).isEmpty()) {
            return result;
        }
        PartialResultFailedException partialEx = new PartialResultFailedException(null, result.getRequestId(), result);
        for (BulkImportResponse.RowResult rowResult : failedRows) {
            TableStoreException ex = new TableStoreException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestId(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.traceLogger, this.retry, ex, result.getRequestId());
        }
        throw partialEx;
    }
}

