/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CalculateV4SigningKeyUtil {
    private static String PREFIX = "aliyun_v4";
    private static String CONSTANT = "aliyun_v4_request";
    private static final Object LOCK = new Object();
    private static Mac macInstance;

    public static byte[] firstSigningKey(String secret, String date, String signMethod) {
        Mac mac = null;
        try {
            mac = CalculateV4SigningKeyUtil.initMac(signMethod);
            mac.init(new SecretKeySpec((PREFIX + secret).getBytes("UTF-8"), signMethod));
            return mac.doFinal(date.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncoding");
        }
    }

    public static byte[] regionSigningKey(String secret, String date, String region, String signMethod) {
        byte[] firstSignkey = CalculateV4SigningKeyUtil.firstSigningKey(secret, date, signMethod);
        Mac mac = null;
        try {
            mac = CalculateV4SigningKeyUtil.initMac(signMethod);
            mac.init(new SecretKeySpec(firstSignkey, signMethod));
            return mac.doFinal(region.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncoding");
        }
    }

    public static String regionSigningKeyString(String secret, String date, String region, String signMethod) {
        return Base64.toBase64String(CalculateV4SigningKeyUtil.regionSigningKey(secret, date, region, signMethod));
    }

    public static byte[] finalSigningKey(String secret, String date, String region, String productCode, String signMethod) {
        byte[] secondSignify = CalculateV4SigningKeyUtil.regionSigningKey(secret, date, region, signMethod);
        Mac mac = null;
        try {
            mac = CalculateV4SigningKeyUtil.initMac(signMethod);
            mac.init(new SecretKeySpec(secondSignify, signMethod));
            byte[] thirdSigningKey = mac.doFinal(productCode.getBytes("UTF-8"));
            mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(thirdSigningKey, signMethod));
            return mac.doFinal(CONSTANT.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncoding");
        }
    }

    public static String finalSigningKeyString(String secret, String date, String region, String productCode, String signMethod) {
        return Base64.toBase64String(CalculateV4SigningKeyUtil.finalSigningKey(secret, date, region, productCode, signMethod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mac initMac(String signMethod) throws NoSuchAlgorithmException {
        if (macInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (macInstance == null) {
                    macInstance = Mac.getInstance(signMethod);
                }
            }
        }
        try {
            return (Mac)macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            return Mac.getInstance(signMethod);
        }
    }
}

