/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClient;
import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreTimeseriesWriter;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesBucket;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesWriterResult;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesWriterUtils;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesWriterConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.dispatch.TimeseriesBaseDispatcher;
import com.alicloud.openservices.tablestore.timeserieswriter.dispatch.TimeseriesHashPKDispatcher;
import com.alicloud.openservices.tablestore.timeserieswriter.dispatch.TimeseriesRoundRobinDispatcher;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import com.alicloud.openservices.tablestore.writer.retry.CertainCodeNotRetryStrategy;
import com.alicloud.openservices.tablestore.writer.retry.CertainCodeRetryStrategy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableStoreTimeseriesWriter
implements TableStoreTimeseriesWriter {
    private static Logger logger = LoggerFactory.getLogger(DefaultTableStoreTimeseriesWriter.class);
    private static final int SCHEDULED_CORE_POOL_SIZE = 2;
    private TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics;
    private final AsyncTimeseriesClientInterface ots;
    private final TimeseriesWriterConfig timeseriesWriterConfig;
    private final Executor executor;
    private TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback;
    private Boolean allowDuplicatePkInBatchRequest;
    private final Semaphore semaphore;
    private Boolean isInnerConstruct;
    private TimeseriesBucket[] timeseriesBuckets;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private TimeseriesBaseDispatcher dispatcher;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "time-series-writer-scheduled-pool-%d" + this.counter.getAndIncrement());
        }
    });

    public DefaultTableStoreTimeseriesWriter(AsyncTimeseriesClientInterface ots, TimeseriesWriterConfig config, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback, Executor executor) {
        Preconditions.checkNotNull(ots, "The ots client can not be null.");
        Preconditions.checkNotNull(executor, "The executor service can not be null.");
        this.timeseriesWriterHandleStatistics = new TimeseriesWriterHandleStatistics();
        this.ots = ots;
        this.timeseriesWriterConfig = config;
        this.resultCallback = this.createResultCallback(callback);
        this.executor = executor;
        this.allowDuplicatePkInBatchRequest = this.timeseriesWriterConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.timeseriesWriterConfig.getConcurrency());
        this.isInnerConstruct = false;
        this.initialize();
        this.closed.set(false);
    }

    public DefaultTableStoreTimeseriesWriter(String endpoint, ServiceCredentials credentials, String instanceName, TimeseriesWriterConfig config, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback) {
        this.allowDuplicatePkInBatchRequest = true;
        this.timeseriesWriterHandleStatistics = new TimeseriesWriterHandleStatistics();
        ClientConfiguration cc = new ClientConfiguration();
        cc.setMaxConnections(config.getClientMaxConnections());
        switch (config.getWriterRetryStrategy()) {
            case CERTAIN_ERROR_CODE_NOT_RETRY: {
                cc.setRetryStrategy(new CertainCodeNotRetryStrategy());
                break;
            }
            default: {
                cc.setRetryStrategy(new CertainCodeRetryStrategy());
            }
        }
        this.ots = new AsyncTimeseriesClient(endpoint, new DefaultCredentialProvider(credentials), instanceName, cc, new ResourceManager(cc, null));
        this.timeseriesWriterConfig = config;
        this.resultCallback = resultCallback;
        this.executor = this.createThreadPool(config);
        this.allowDuplicatePkInBatchRequest = this.timeseriesWriterConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.timeseriesWriterConfig.getConcurrency());
        this.isInnerConstruct = true;
        this.initialize();
        this.closed.set(false);
    }

    public DefaultTableStoreTimeseriesWriter(String endpoint, ServiceCredentials credentials, String instanceName, TimeseriesWriterConfig config, ClientConfiguration cc, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback) {
        this.allowDuplicatePkInBatchRequest = true;
        this.timeseriesWriterHandleStatistics = new TimeseriesWriterHandleStatistics();
        this.ots = new AsyncTimeseriesClient(endpoint, new DefaultCredentialProvider(credentials), instanceName, cc, new ResourceManager(cc, null));
        this.timeseriesWriterConfig = config;
        this.resultCallback = resultCallback;
        this.executor = this.createThreadPool(config);
        this.allowDuplicatePkInBatchRequest = this.timeseriesWriterConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.timeseriesWriterConfig.getConcurrency());
        this.isInnerConstruct = true;
        this.initialize();
        this.closed.set(false);
    }

    private void initialize() {
        logger.info("Start initialize time series ots writer.");
        this.timeseriesBuckets = new TimeseriesBucket[this.timeseriesWriterConfig.getBucketCount()];
        for (int i = 0; i < this.timeseriesWriterConfig.getBucketCount(); ++i) {
            TimeseriesBucketConfig timeseriesBucketConfig = new TimeseriesBucketConfig(i, this.timeseriesWriterConfig.getWriteMode(), this.allowDuplicatePkInBatchRequest);
            this.timeseriesBuckets[i] = new TimeseriesBucket(timeseriesBucketConfig, this.ots, this.timeseriesWriterConfig, this.resultCallback, this.executor, this.timeseriesWriterHandleStatistics, this.semaphore);
        }
        switch (this.timeseriesWriterConfig.getDispatchMode()) {
            case HASH_PRIMARY_KEY: {
                this.dispatcher = new TimeseriesHashPKDispatcher(this.timeseriesWriterConfig.getBucketCount());
                break;
            }
            case ROUND_ROBIN: {
                this.dispatcher = new TimeseriesRoundRobinDispatcher(this.timeseriesWriterConfig.getBucketCount());
                break;
            }
            default: {
                throw new ClientException(String.format("The dispatch mode [%s] not supported", new Object[]{this.timeseriesWriterConfig.getDispatchMode()}));
            }
        }
        this.startFlushTimer(this.timeseriesWriterConfig.getFlushInterval());
        this.startLogTimer(this.timeseriesWriterConfig.getLogInterval());
    }

    private ExecutorService createThreadPool(TimeseriesWriterConfig config) {
        int coreThreadCount = config.getCallbackThreadCount();
        int queueSize = config.getCallbackThreadPoolQueueSize();
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "writer-callback-" + this.counter.getAndIncrement());
            }
        };
        return new ThreadPoolExecutor(coreThreadCount, coreThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void startFlushTimer(int flushInterval) {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultTableStoreTimeseriesWriter.this.triggerFlush();
            }
        }, 0L, flushInterval, TimeUnit.MILLISECONDS);
    }

    private CountDownLatch triggerFlush() {
        CountDownLatch latch = new CountDownLatch(this.timeseriesWriterConfig.getBucketCount());
        for (TimeseriesBucket bucket : this.timeseriesBuckets) {
            bucket.addSignal(latch);
        }
        logger.info("TimeseriesWriterStatistics: " + this.timeseriesWriterHandleStatistics);
        return latch;
    }

    private void startLogTimer(int interval) {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StringBuilder ringBufferRemain = new StringBuilder("RingBuffer Remain: ");
                for (TimeseriesBucket timeseriesBucket : DefaultTableStoreTimeseriesWriter.this.timeseriesBuckets) {
                    ringBufferRemain.append(timeseriesBucket.getRingBuffer().remainingCapacity());
                    ringBufferRemain.append(", ");
                }
                logger.debug(ringBufferRemain.toString());
                StringBuilder dispatcherCount = new StringBuilder("Dispatcher Count: ");
                for (AtomicLong count : DefaultTableStoreTimeseriesWriter.this.dispatcher.getBucketDispatchRowCount()) {
                    dispatcherCount.append(count.get());
                    dispatcherCount.append(", ");
                }
                logger.debug(dispatcherCount.toString());
            }
        }, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> createResultCallback(final TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback) {
        if (callback != null) {
            return new TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult>(){

                @Override
                public void onCompleted(TimeseriesTableRow req, TimeseriesRowResult res) {
                    callback.onCompleted(req, res);
                }

                @Override
                public void onFailed(TimeseriesTableRow req, Exception ex) {
                    callback.onFailed(req, ex);
                }
            };
        }
        return null;
    }

    @Override
    public void addTimeseriesRowChange(TimeseriesTableRow timeseriesTableRow) throws ClientException {
        this.checkTimeseriesTableRow(timeseriesTableRow);
        TimeseriesGroup timeseriesGroup = new TimeseriesGroup(1);
        while (!this.addTimeseriesRowInternal(timeseriesTableRow, timeseriesGroup)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean addTimeseriesRowInternal(TimeseriesTableRow timeseriesTableRow, TimeseriesGroup timeseriesGroup) {
        if (this.closed.get()) {
            throw new ClientException("The time series writer has been closed.");
        }
        int targetBucketIndex = this.dispatcher.getDispatchIndex(timeseriesTableRow.getTimeseriesRow());
        return this.timeseriesBuckets[targetBucketIndex].addRowChange(timeseriesTableRow, timeseriesGroup);
    }

    private void checkTimeseriesTableRow(TimeseriesTableRow timeseriesTableRow) {
        Preconditions.checkArgument(timeseriesTableRow.getTableName() != null && !timeseriesTableRow.getTableName().isEmpty(), "The table name can not be null or empty.");
        TimeseriesWriterUtils.checkMeasurement(timeseriesTableRow.getTimeseriesRow());
    }

    @Override
    public Future<TimeseriesWriterResult> addTimeseriesRowChangeWithFuture(TimeseriesTableRow timeseriesTableRow) throws ClientException {
        this.checkTimeseriesTableRow(timeseriesTableRow);
        TimeseriesGroup timeseriesGroup = new TimeseriesGroup(1);
        while (!this.addTimeseriesRowInternal(timeseriesTableRow, timeseriesGroup)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return timeseriesGroup.getFuture();
    }

    @Override
    public boolean tryAddTimeseriesRowChange(TimeseriesTableRow timeseriesTableRow) throws ClientException {
        this.checkTimeseriesTableRow(timeseriesTableRow);
        TimeseriesGroup timeseriesGroup = new TimeseriesGroup(1);
        return this.addTimeseriesRowInternal(timeseriesTableRow, timeseriesGroup);
    }

    @Override
    public void addTimeseriesRowChange(List<TimeseriesTableRow> timeseriesTableRows, List<TimeseriesTableRow> dirtyTimeseriesTableRows) throws ClientException {
        dirtyTimeseriesTableRows.clear();
        for (TimeseriesTableRow timeseriesTableRow : timeseriesTableRows) {
            this.checkTimeseriesTableRow(timeseriesTableRow);
            try {
                this.addTimeseriesRowChange(timeseriesTableRow);
            }
            catch (ClientException e) {
                dirtyTimeseriesTableRows.add(timeseriesTableRow);
            }
        }
        if (!dirtyTimeseriesTableRows.isEmpty()) {
            throw new ClientException("There is dirty rows.");
        }
    }

    @Override
    public Future<TimeseriesWriterResult> addTimeseriesRowChangeWithFuture(List<TimeseriesTableRow> timeseriesTableRows) throws ClientException {
        TimeseriesGroup timeseriesGroup = new TimeseriesGroup(timeseriesTableRows.size());
        for (TimeseriesTableRow timeseriesTableRow : timeseriesTableRows) {
            try {
                while (!this.addTimeseriesRowInternal(timeseriesTableRow, timeseriesGroup)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (ClientException e) {
                timeseriesGroup.failedOneRow(timeseriesTableRow, e);
            }
        }
        return timeseriesGroup.getFuture();
    }

    @Override
    public void setResultCallback(TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback) {
        this.resultCallback = resultCallback;
        for (TimeseriesBucket bucket : this.timeseriesBuckets) {
            bucket.setResultCallback(resultCallback);
        }
    }

    @Override
    public TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> getResultCallback() {
        return this.resultCallback;
    }

    @Override
    public TimeseriesWriterConfig getTimeseriesWriterConfig() {
        return this.timeseriesWriterConfig;
    }

    @Override
    public TimeseriesWriterHandleStatistics getTimeseriesWriterStatistics() {
        return this.timeseriesWriterHandleStatistics;
    }

    @Override
    public void flush() throws ClientException {
        logger.debug("trigger flush and waiting.");
        if (this.closed.get()) {
            throw new ClientException("The writer has been closed.");
        }
        CountDownLatch latch = this.triggerFlush();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        logger.debug("user trigger flush finished.");
    }

    @Override
    public void close() {
        if (this.closed.get()) {
            throw new ClientException("The writer has already been closed.");
        }
        this.flush();
        this.scheduledExecutorService.shutdown();
        for (TimeseriesBucket timeseriesBucket : this.timeseriesBuckets) {
            timeseriesBucket.close();
            logger.debug(String.format("bucket [%d] is closed.", timeseriesBucket.getId()));
        }
        if (this.isInnerConstruct.booleanValue()) {
            this.ots.shutdown();
            ((ExecutorService)this.executor).shutdown();
        }
        this.closed.set(true);
    }
}

