# 使用JavaScript SDK + STS SDK安全采集浏览器日志到SLS

这是一个使用 @aliyun-sls/web-track-browser 和 @aliyun-sls/web-sts-plugin 来展示如何在浏览器中集成和使用阿里云日志服务（Simple Log Service, SLS）和安全令牌服务（Security Token Service, STS）安全地进行用户行为跟踪的示例工程。

以下步骤将指导你如何在ECS环境中运行并测试这个示例工程。

## 前提条件
在开始之前，请确保你已满足以下条件：

- 已创建ECS
- 已创建通过OpenAPI访问的RAM用户，并授予AssumeRole权限
- 已创建RAM角色，并授予AssumeRole权限以及上传日志到日志服务的权限
- 已创建SLS Project和Logstore

## 连接ECS实例

通过 SSH 连接 ECS 实例。

```
ssh root@<ECS实例公网IP>
```

## 安装依赖
在项目目录下运行以下命令来安装必要的依赖项：
```
yum install python3 -y

pip3 install Flask

pip3 install attr

pip3 install yarl

pip3 install async_timeout

pip3 install idna_ssl

pip3 install attrs

ip3 install aiosignal

pip3 install charset_normalizer

pip3 install alibabacloud_tea_openapi

pip3 install alibabacloud_sts20150401

pip3 install alibabacloud_credentials

yum install npm -y

npm install -g parcel-bundler

npm install --save @aliyun-sls/web-track-browser

npm install --save @aliyun-sls/web-sts-plugin
```

## 配置项目
配置访问密钥、地域、RAM角色、SLS Project和Logstore、RAM会话名称、ECS公网IP：
```
export ALIBABA_CLOUD_ACCESS_KEY_ID=${AccessKey.AccessKeyId}

export ALIBABA_CLOUD_ACCESS_KEY_SECRET=${AccessKey.AccessKeySecret}

export YOUR_REGION_ID=${ALIYUN::Region}

export YOUR_ROLE_ARN=${WebTrackingRole.Arn}

export ALIYUN_LOG_PROJECT=${Project.Name}

export ALIYUN_LOG_LOGSTORE=${LogStore.LogstoreName}

export YOUR_ROLE_SESSION_NAME=web-tracking-sts

export YOUR_PUBLIC_IP=${ECS_pub_Ip}
```
## 运行项目
构建并运行项目：
```
parcel build src/index.js --out-dir static/js --public-url/static/js

nohup python3 main.py &
```

## 访问Web应用
打开浏览器并访问以下 URL：
```
http://<ECS公网IP>
```
将 <ECS公网IP> 替换为你的 ECS 实例的公网 IP。

## 测试
确保所有配置正确无误之后，你可以进行如下操作来测试SDK功能是否正常：
- 在浏览器中导航、点击等，根据示例代码的设定，这些行为应该触发数据上报。
- 登录你的阿里云 SLS 控制台，通过消费预览查看日志。