/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.internals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.Gauge;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;

public final class IntGaugeSuite<K>
implements AutoCloseable {
    private final Logger log;
    private final String suiteName;
    private final Metrics metrics;
    private final Function<K, MetricName> metricNameCalculator;
    private final int maxEntries;
    private final Map<K, StoredIntGauge> gauges;
    private final Set<K> removable;
    private final ConcurrentLinkedDeque<PendingMetricsChange> pending;
    private final Lock modifyMetricsLock;
    private boolean closed;

    public IntGaugeSuite(Logger log, String suiteName, Metrics metrics, Function<K, MetricName> metricNameCalculator, int maxEntries) {
        this.log = log;
        this.suiteName = suiteName;
        this.metrics = metrics;
        this.metricNameCalculator = metricNameCalculator;
        this.maxEntries = maxEntries;
        this.gauges = new HashMap<K, StoredIntGauge>(1);
        this.removable = new HashSet<K>();
        this.pending = new ConcurrentLinkedDeque();
        this.modifyMetricsLock = new ReentrantLock();
        this.closed = false;
        log.trace("{}: created new gauge suite with maxEntries = {}.", (Object)suiteName, (Object)maxEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(K key) {
        IntGaugeSuite intGaugeSuite = this;
        synchronized (intGaugeSuite) {
            if (this.closed) {
                this.log.warn("{}: Attempted to increment {}, but the GaugeSuite was closed.", (Object)this.suiteName, (Object)key.toString());
                return;
            }
            StoredIntGauge gauge = this.gauges.get(key);
            if (gauge != null) {
                if (gauge.increment() > 0) {
                    this.removable.remove(key);
                }
                return;
            }
            if (this.gauges.size() == this.maxEntries) {
                if (this.removable.isEmpty()) {
                    this.log.debug("{}: Attempted to increment {}, but there are already {} entries.", new Object[]{this.suiteName, key.toString(), this.maxEntries});
                    return;
                }
                Iterator<K> iter = this.removable.iterator();
                K keyToRemove = iter.next();
                iter.remove();
                MetricName metricNameToRemove = this.gauges.get(keyToRemove).metricName;
                this.gauges.remove(keyToRemove);
                this.pending.push(new PendingMetricsChange(metricNameToRemove, null));
                this.log.trace("{}: Removing the metric {}, which has a value of 0.", (Object)this.suiteName, (Object)keyToRemove.toString());
            }
            MetricName metricNameToAdd = this.metricNameCalculator.apply(key);
            gauge = new StoredIntGauge(metricNameToAdd);
            this.gauges.put(key, gauge);
            this.pending.push(new PendingMetricsChange(metricNameToAdd, gauge));
            this.log.trace("{}: Adding a new metric {}.", (Object)this.suiteName, (Object)key.toString());
        }
        this.performPendingMetricsOperations();
    }

    private void performPendingMetricsOperations() {
        this.modifyMetricsLock.lock();
        try {
            this.log.trace("{}: entering performPendingMetricsOperations", (Object)this.suiteName);
            PendingMetricsChange change = this.pending.pollLast();
            while (change != null) {
                if (change.provider == null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{}: removing metric {}", (Object)this.suiteName, (Object)change.metricName);
                    }
                    this.metrics.removeMetric(change.metricName);
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{}: adding metric {}", (Object)this.suiteName, (Object)change.metricName);
                    }
                    this.metrics.addMetric(change.metricName, change.provider);
                }
                change = this.pending.pollLast();
            }
            this.log.trace("{}: leaving performPendingMetricsOperations", (Object)this.suiteName);
        }
        finally {
            this.modifyMetricsLock.unlock();
        }
    }

    public synchronized void decrement(K key) {
        if (this.closed) {
            this.log.warn("{}: Attempted to decrement {}, but the gauge suite was closed.", (Object)this.suiteName, (Object)key.toString());
            return;
        }
        StoredIntGauge gauge = this.gauges.get(key);
        if (gauge == null) {
            this.log.debug("{}: Attempted to decrement {}, but no such metric was registered.", (Object)this.suiteName, (Object)key.toString());
        } else {
            int cur = gauge.decrement();
            this.log.trace("{}: Removed a reference to {}.  {} reference(s) remaining.", new Object[]{this.suiteName, key.toString(), cur});
            if (cur <= 0) {
                this.removable.add(key);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            this.log.trace("{}: gauge suite is already closed.", (Object)this.suiteName);
            return;
        }
        this.closed = true;
        int prevSize = 0;
        Iterator<StoredIntGauge> iter = this.gauges.values().iterator();
        while (iter.hasNext()) {
            this.pending.push(new PendingMetricsChange(iter.next().metricName, null));
            ++prevSize;
            iter.remove();
        }
        this.performPendingMetricsOperations();
        this.log.trace("{}: closed {} metric(s).", (Object)this.suiteName, (Object)prevSize);
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    Metrics metrics() {
        return this.metrics;
    }

    synchronized Map<K, Integer> values() {
        HashMap<K, Integer> values = new HashMap<K, Integer>();
        for (Map.Entry<K, StoredIntGauge> entry : this.gauges.entrySet()) {
            values.put(entry.getKey(), entry.getValue().value());
        }
        return values;
    }

    private static class StoredIntGauge
    implements Gauge<Integer> {
        private final MetricName metricName;
        private int value;

        StoredIntGauge(MetricName metricName) {
            this.metricName = metricName;
            this.value = 1;
        }

        @Override
        public synchronized Integer value(MetricConfig config, long now) {
            return this.value;
        }

        synchronized int increment() {
            return ++this.value;
        }

        synchronized int decrement() {
            return --this.value;
        }

        synchronized int value() {
            return this.value;
        }
    }

    private static class PendingMetricsChange {
        private final MetricName metricName;
        private final MetricValueProvider<?> provider;

        PendingMetricsChange(MetricName metricName, MetricValueProvider<?> provider) {
            this.metricName = metricName;
            this.provider = provider;
        }
    }
}

