#!/bin/bash

ContentPath=$1
ContentPass=$2
ContentPassID=$3

if [ -z $ContentPath ]
then
    echo "ContentPath is not exist"
    exit 1
else
    ContentPath=${ContentPath%*/}
    echo "ContentPath: ${ContentPath}"
fi

if [ -z $ContentPass ]
then
    echo "ContentPass is not set"
    exit 1
else
    echo "ContentPass: ${ContentPass}"
fi

if [ -z $ContentPassID ]
then
    echo "ContentPassID is not set"
    exit 1
else
    echo "ContentPassID: ${ContentPassID}"
    sed -i 's/"license_id":[^,]*/"license_id": "'${ContentPassID}'"/' license_info.json
fi

echo -e '\n'

function SetContentCipherSize(){
    ContentFileSize=$(ls -l $1 | awk '{ print $5 }')
    ContentFileSize=$(expr $ContentFileSize / 1024 / 1024)

    if [ ${ContentFileSize} -ge 4096 ]
    then
        ContentCipherSize=256.0
    elif [ ${ContentFileSize} -ge 1024 ]
    then
        ContentCipherSize=128.0
    else
        ContentCipherSize=64.0
    fi

    echo "ContentCipherSize: ${ContentCipherSize}"

    sed -i 's/"enc_size":[^,]*/"enc_size": '${ContentCipherSize}'/' protect_config.json
}

function SetContentLicenseFileName(){
    if [ -f ${ContentPassID}/sam.lic ]
    then
        rm -f ${ContentPassID}/sam.lic
    fi

    mv ${ContentPassID}/*.lic ${ContentPassID}/sam.lic
}

function SetContentCipherFileName(){
    for item in `find $ContentPassID -name *.enc`
    do
        mv $item ${item%.*}
    done
}

function ContentFilePackager(){
    ContentFile=$1

    echo -e "------------------------------ ContentFile: $ContentFile"

    SetContentCipherSize $ContentFile

    ./bin/content_packager --input ${ContentFile}  --license license_info.json --config protect_config.json --password ${ContentPass}

    echo -e "\n"
}

function ContentPathPackager(){
    for item in `ls $1`
    do
        SrcFile=$1"/"$item
        DstFile=$2"/"$item

        if [ -d $SrcFile ]
        then
            ContentPathPackager $SrcFile $DstFile
        else
            if [ -f $SrcFile ]
            then
                ContentFilePackager $SrcFile

                EncFile=$ContentPassID"/"$item".enc"
                if [ ! -e $EncFile ]
                then
                    echo "Not Found Encrypted Content File: $EncFile"
                    exit 1
                else
                    mkdir -p $(dirname ${DstFile})
                    mv $EncFile $DstFile
                fi
            else
                echo "Not Support This Content File: $SrcFile"
                exit 1
            fi
        fi
    done
}

function ContentPackager(){
    if [ -f $ContentPath ]
    then
        ContentFilePackager $ContentPath
        SetContentCipherFileName
    else
        ContentPathPackager $ContentPath $ContentPassID
    fi

    SetContentLicenseFileName
}

echo -e '--------------------------------------------------------------------------------------------------------------> Content Packager Start'
echo -e ''

ContentPackager $ContentPath

echo -e '<-------------------------------------------------------------------------------------------------------------- Content Packager Finished'
echo -e ''

