package com.lingyang.qaexchanger.lingyangqaexchanger.util;

import org.apache.commons.codec.digest.HmacUtils;

import java.util.Arrays;


/**
 * @Description: Webhook签名算法工具类
 * @Title: WebhookSignUtil
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.util
 * @Author: Jason
 * @Copyright Lingyang
 * @CreateTime: 2022/5/11 10:51
 */
public class WebhookSignUtil {

    /**
     * 签名验证
     *
     * @param key 密钥信息
     * @param timestamp 秒级时间戳
     * @param nonce 32位随机字符串
     * @param signature 请求参数签名
     * @return
     */
    public static boolean makeSignature(String key, String timestamp, String nonce, String signature) {
        String str = generateStr(key, timestamp, nonce);
        return str.equals(signature);
    }

    /**
     * 签名生成
     *
     * @param key 密钥信息
     * @param timestamp 秒级时间戳
     * @param nonce 32位随机字符串
     * @return
     */
    public static String generateStr(String key, String timestamp, String nonce) {
        String[] array = new String[] { key, timestamp, nonce};
        StringBuffer sb = new StringBuffer();
        // 字符串排序
        Arrays.sort(array);
        for (int i = 0; i < 3; i++) {
            sb.append(array[i]);
        }
        String hexStr = HmacUtils.hmacSha256Hex(key, sb.toString().replaceAll("\\s+", ""));
        return hexStr;
    }

}