package com.lingyang.qaexchanger.lingyangqaexchanger.util;


import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

/**
 * @Description: 优惠券回调地址请求参数顾客信息传输对象
 * @Title: PropsUtil
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.util
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/8 23:00
 */
@Slf4j
public class PropsUtil {

    // 业务异常配置文件
    private static final String MESSAGE_FILE = "messages_zh_CN.properties";
    private static Properties messageProps;

    static {
        messageProps = getPropertiesFromClassPathByAppConst(MESSAGE_FILE);
    }

    public static void reload() {
        messageProps = getPropertiesFromClassPathByAppConst(MESSAGE_FILE);
    }

    public static String getProperty(String propName) {
        if (messageProps == null) {
            log.error("messages_zh_CN.properties did not initialize yet");
            return null;
        }
        return messageProps.getProperty(propName);
    }

    public static boolean containsKey(String propName) {
        return messageProps.containsKey(propName);
    }

    public static Map<String, Properties> getInstance() {
        Map<String, Properties> props = new HashMap<String, Properties>();
        props.put("messageProps", messageProps);
        return props;
    }

    /**
     * 加载类路径下的配置文件
     *
     * @param fileName 文件名称
     * @return
     */
    public static Properties getPropertiesFromClassPathByAppConst(String fileName) {
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = PropsUtil.class.getClassLoader().getResourceAsStream(fileName);
            Properties properties = new Properties();
            properties.load(resourceAsStream);
            return properties;
        } catch (IOException e) {
            log.error("Could not load Properties file : '" + fileName + "' ", e);
            return null;
        } finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                } catch (IOException e) {
                    e.printStackTrace();// no need to log
                }
            }
        }
    }
}
