package com.lingyang.qaexchanger.lingyangqaexchanger.util;


import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {

    /**
     * 中文的年月格式yyyy年MM月
     */
    public static final String CHINA_FORMAT_YEAR_MONTH = "yyyy年MM月";
    public static final String FORMAT_YEAR_MONTH = "yyyyMM";
    public static final String FORMAT_YEAR_MONTH_DAY = "yyyyMMdd";
    public static final String CHINA_FORMAT_YEAR_MONTH_DAY = "yyyy年MM月dd日";
    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_1 = "yyyy-MM-dd HH:mm:ss";

    /**
     * 格式化日期
     *
     * @param intDate 201305
     * @param pattern
     * @return
     * @throws Exception
     * @author CNVISD61
     * @date 2013-7-17
     */
    public static String format(String intDate, String pattern) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YEAR_MONTH);
        Date newDate = format.parse(intDate);
        return format(newDate, pattern);
    }

    /**
     * 根据固定格式解析日期对象
     *
     * @param date
     * @return
     */
    public static String formatYYYYMMDDhlingyangmss(Date date) {
        if (null == date) return "";
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE_1);
            return formatter.format(date);
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 根据固定格式解析字符串
     *
     * @param time
     * @return
     * @throws
     */
    public static Date parseFromYYYYMMDDhlingyangmss(String time) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE_1);
        return formatter.parse(time);
    }

    /**
     * 获取秒数偏移后的时间
     *
     * @param date
     * @param amount 偏移量
     * @return
     */
    public static Date rollSecond(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.SECOND, amount);
        return calendar.getTime();
    }

    /**
     * 获取分钟数偏移后的时间
     *
     * @param date
     * @param amount 偏移量
     * @return
     */
    public static Date rollMinute(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE, amount);
        return calendar.getTime();
    }

    /**
     * 获取小时数偏移后的时间
     *
     * @param date
     * @param amount 偏移量
     * @return
     */
    public static Date rollHour(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR, amount);
        return calendar.getTime();
    }

    /**
     * 获取天数偏移后的时间
     *
     * @param date
     * @param amount 偏移量
     * @return
     */
    public static Date rollDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_YEAR, amount);
        return calendar.getTime();
    }

    /**
     * 获取时间差
     */
    public static int getDistanceTimes(Date d1, Date d2) {
        long day = 0;
        try {
            long time1 = d1.getTime();
            long time2 = d2.getTime();
            long diff;
            if (time1 < time2) {
                diff = time2 - time1;
            } else {
                diff = time1 - time2;
            }
            day = diff / (24 * 60 * 60 * 1000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (int) day;
    }

    /**
     * 将字符串解析成Date类型
     *
     * @param s
     * @param format
     * @return
     * @throws Exception
     */
    public static Date parse(String s, String format) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(format);

        // bycobe 20130307: 若字符串长度与format长度不一致，则前面补0
        int len = format.length() - s.length();
        for (int i = 0; i < len; i++) {
            s = "0" + s;
        }

        return formatter.parse(s);
    }

    /**
     * 将字符串型时间转成时间戳，日期默认为系统日期
     *
     * @param strTime 字符串型时间
     * @return 时间戳型
     */
    public static Timestamp strTime2Timestamp(String strTime) {
        Timestamp timestamp = null;
        try {
            timestamp = Timestamp.valueOf(strTime);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return timestamp;
    }

    /**
     * 格式化日期
     *
     * @param date
     * @param pattern
     * @return
     */
    public static String format(Date date, String pattern) {
        DateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    /**
     * 将字符串解析成Date类型
     *
     * @param s
     * @param format
     * @return
     * @throws Exception
     */
    public static Date parseToDate(String s, String format) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(format);

        // bycobe 20130307: 若字符串长度与format长度不一致，则前面补0
        int len = format.length() - s.length();
        for (int i = 0; i < len; i++) {
            s = "0" + s;
        }

        return formatter.parse(s);
    }

    /**
     * 获取月份
     *
     * @param t 0:当前月份, -1:上月月份, -2:上上月月份
     * @return YYYYMM
     */
    public static String getMonth(int t) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.add(Calendar.MONTH, t);
        String timeString = new SimpleDateFormat("yyyyMM").format(calendar.getTime());

        return timeString;
    }

    /**
     * 获取指定月份
     *
     * @param t 0:指定月份, -1:指定月份的上月, -2:指定月份的上上月月份
     * @return YYYY年MM月
     */
    public static String getMonthByMonthStr(int year, int month, int t) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(year, month, 0);
        calendar.add(Calendar.MONTH, t);
        String timeString = new SimpleDateFormat("yyyyMM").format(calendar.getTime());

        return timeString;
    }

    /**
     * 转换日历,格式为yyyyMM
     *
     * @param date
     * @return String
     */
    public static String date2Month(Date date) {
        return format(date, FORMAT_YEAR_MONTH);
    }

    /**
     * 将传入的日期date增加或减少months个月，并返回增加或减少月份后的日期。当months为正数，即表示增加月份，当months为负数，
     * 即表示减少月份
     *
     * @param date
     * @param months
     * @return Date
     */
    public static Date getAddMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MONTH, months);
        return cal.getTime();
    }

    public static String getCurrentTimeStr() {
        Date today = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        String curTime = format.format(today);

        return curTime;

    }

    public static String getFormatTimeStr(Date newDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        String curTime = format.format(newDate);

        return curTime;

    }

    public static Date addHours(String curTime, int duration) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date curDate = format.parse(curTime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(Calendar.HOUR, duration);// 24小时制
        Date newDate = cal.getTime();

        return newDate;
    }

    /**
     * 获取月的第一天
     *
     * @param date
     * @return date
     */
    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        return calendar.getTime();
    }

    /**
     * 获取月的最后一天
     *
     * @param date
     * @return date
     */
    public static Date getMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        return calendar.getTime();
    }

    /**
     * 返回过期时间的当天最后一刻
     *
     * @param expireDate
     * @return
     */
    public static Date getExpireDateAtLast(Date expireDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(expireDate);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return calendar.getTime();
    }

    /**
     * 获取日期的结束时间
     *
     * @return
     */
    public static Date dateEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_YEAR, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.SECOND, -1);
        return calendar.getTime();
    }

    /**
     * 获取月份偏移后的时间
     *
     * @param date
     * @param amount 偏移量
     * @param isInitDay 是否初始化当月首天
     * @param isInitTime 是否初始化当天凌晨
     * @return
     */
    public static Date rollMonth(Date date, int amount, boolean isInitDay, boolean isInitTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, amount);
        if (isInitDay) {
            calendar.set(Calendar.DAY_OF_MONTH, 1);
        }
        if (isInitTime) {
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
        }
        return calendar.getTime();
    }

    /**
     * 获取YYYY-MM-DD 时间格式
     *
     * @param dateStr
     * @return
     */
    public static String strToDataShort(String dateStr) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(dateStr, pos);
        return formatter.format(strtodate);
    }

    /**
     * 获取当天凌晨6点
     *
     * @return
     */
    public static Date getTodayDateAtAm6() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 6);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取明天凌晨6点
     *
     * @return
     */
    public static Date getTomorrowDateAtAm6() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 6);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.HOUR, 24);
        return calendar.getTime();
    }

    /**
     * 返回当天剩余时间，单位秒
     *
     * @return
     */
    public static long getCurrentRestDayTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return (calendar.getTimeInMillis() - System.currentTimeMillis()) / 1000;
    }
}
