package com.lingyang.qaexchanger.lingyangqaexchanger.util;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;


/**
 * @Description: AES加解密工具
 * @Title: AesUtil
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.util
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/8 23:00
 */
@Component
public class AesUtil {

    private static String encryptKey;

    private static String ivParameterSpecKey;

    /**
     * 加密算法模式
     */
    private final static String ALGORITHM = "AES/CBC/PKCS5Padding";
    /**
     * 加密算法模式
     */
    private final static String AES = "AES";

    @Value("${business.auth.aes.secret-key}")
    public void setKey(String k) {
        encryptKey = k;
    }

    @Value("${business.auth.aes.parameter-spec-key}")
    public void setParameterSpecKey(String parameterSpecKey) {
        ivParameterSpecKey = parameterSpecKey;
    }

    /**
     * AES加密
     *
     * @param content 需要加密的内容
     * @return 加密后内容，已由2进制转为base64编码
     */
    public static String encryptData(String content)
            throws Exception {
        if (content == null || encryptKey == null || ivParameterSpecKey == null) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(encryptKey.getBytes(), AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, keySpec, new IvParameterSpec(ivParameterSpecKey.getBytes()));
        byte[] result = cipher.doFinal(content.getBytes());
        return base64Encoder(result);
    }

    /**
     * AES解密
     *
     * @param content 待解密内容，必须为经AES加密后转为base64编码的字符串
     * @return 解密后的内容
     * @throws Exception
     */
    public static String decryptData(String content)
            throws Exception {
        if (content == null || encryptKey == null || ivParameterSpecKey == null) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(encryptKey.getBytes(), AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, keySpec, new IvParameterSpec(ivParameterSpecKey.getBytes()));
        byte[] result = cipher.doFinal(base64Decoder(content));
        return new String(result);
    }

    /**
     * 取得Key
     *
     * @param encryptKey 密钥
     * @return 解密后的内容
     * @throws Exception
     */
    public static SecretKey getSecretKey(String encryptKey) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(
                encryptKey.getBytes(), AES);
        return skeySpec;
    }

    /**
     * 将二进制转换成base64编码
     *
     * @param buf
     * @return
     */
    private static String base64Encoder(byte[] buf) {
        return Base64.getEncoder().encodeToString(buf);
    }

    /**
     * 将base64进制转换为二进制
     *
     * @param base64Str
     * @return
     */
    private static byte[] base64Decoder(String base64Str) {
        return Base64.getDecoder().decode(base64Str);
    }

}