package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.SendCouponsParamsDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.UnionKeyDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookHeaderDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BaseConstants;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BusinessErrorCode;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.IWebhookService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Objects;

/**
 * @Description: Webhook服务实现类
 * @Title: WebhookServiceImpl
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/18 18:28
 */
@Slf4j
@Service
public class WebhookServiceImpl implements IWebhookService {

    @Override
    public WebHookHeaderDTO parseHeaderParam(HttpServletRequest request) {
        WebHookHeaderDTO webHookHeaderDTO = WebHookHeaderDTO.builder()
                .activityId(decoding(request.getHeader("activityId")))
                .activityName(decoding(request.getHeader("activityName")))
                .batchId(decoding(request.getHeader("batchId")))
                .processId(decoding(request.getHeader("processId")))
                .processName(decoding(request.getHeader("processName")))
                .processNodeId(decoding(request.getHeader("processNodeId")))
                .processNodeName(decoding(request.getHeader("processNodeName")))
                .processSchedulerId(decoding(request.getHeader("processSchedulerId")))
                .processSchedulerName(decoding(request.getHeader("processSchedulerName")))
                .processSchedulerStartTime(decoding(request.getHeader("processSchedulerStartTime")))
                .processInstanceStartTime(decoding(request.getHeader("processInstanceStartTime")))
                .subActivityId(decoding(request.getHeader("subActivityId")))
                .subActivityName(decoding(request.getHeader("subActivityName")))
                .jobId(decoding(request.getHeader("jobId")))
                .jobName(decoding(request.getHeader("jobName")))
                .nodeId(decoding(request.getHeader("nodeId")))
                .nodeName(decoding(request.getHeader("nodeName")))
                .nodeStartTimestamp(decoding(request.getHeader("nodeStartTimestamp")))
                .processInstanceId(decoding(request.getHeader("processInstanceId")))
                .processInstanceName(decoding(request.getHeader("processInstanceName")))
                .taskId(decoding(request.getHeader("taskId")))
                .taskStartTimestamp(decoding(request.getHeader("taskStartTimestamp")))
                .build();
        return webHookHeaderDTO;
    }

    @Override
    public UnionKeyDTO parseUnionKey(String unionKey) {
        // processId:processName:processNodeId:processNodeName:processSchedulerId:processSchedulerName:templateId:methodName:sourceId:nonce
        try {
            String[] webhookParam = unionKey.split(BaseConstants.STRING_SPLIT_1);
            return UnionKeyDTO.builder()
                    .processId(webhookParam[0])
                    .processName(webhookParam[1])
                    .processNodeId(webhookParam[2])
                    .processNodeName(webhookParam[3])
                    .processSchedulerId(webhookParam[4])
                    .processSchedulerName(webhookParam[5])
                    .templateId(webhookParam[6])
                    .methodName(webhookParam[7])
                    .sourceId(webhookParam[8])
                    .batchId(webhookParam[9]).build();
        } catch (Exception e) {
            log.error("WEBHOOK_UNION_KEY, parse union key fail. unionKey={}, message={}.", unionKey, e.getMessage());
            throw new BusinessException(BusinessErrorCode.ERROR_0101600, "UnionKey格式不合法");
        }
    }

    @Override
    public String initUnionKey(SendCouponsParamsDTO sendCouponsParamsDTO, WebHookHeaderDTO webHookHeaderDTO, String sourceId) {
        // processId:processName:processNodeId:processNodeName:processSchedulerId:processSchedulerName:templateId:methodName:sourceId:nonce
        StringBuffer unionKey = new StringBuffer()
                .append(webHookHeaderDTO.getProcessId())
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getProcessName())
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getProcessNodeId())
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getProcessNodeName())
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getProcessSchedulerId())
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getProcessSchedulerName())
                .append(BaseConstants.STRING_SPLIT_1).append(sendCouponsParamsDTO.getTemplate_id())
                .append(BaseConstants.STRING_SPLIT_1).append(sendCouponsParamsDTO.getMethod_name())
                .append(BaseConstants.STRING_SPLIT_1).append(sourceId)
                .append(BaseConstants.STRING_SPLIT_1).append(webHookHeaderDTO.getBatchId());
        return unionKey.toString();
    }

    /**
     * 解码处理
     *
     * @param param
     * @return
     */
    private String decoding(Object param) {
        if (Objects.isNull(param)) {
            return null;
        }
        String params = (String) param;
        if (StringUtils.isBlank(params)) {
            return params;
        }
        try {
            return URLDecoder.decode(params, BaseConstants.STRING_UTF8);
        } catch (Exception e) {
            log.warn("WEBHOOK_HEADER, decoding fail params=" + params, e);
        }
        return params;
    }
}
