package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.*;
import com.lingyang.qaexchanger.lingyangqaexchanger.client.req.SendCouponsParamReq;
import com.lingyang.qaexchanger.lingyangqaexchanger.client.req.SendCouponsReq;
import com.lingyang.qaexchanger.lingyangqaexchanger.client.resp.CouponsTemplateResp;
import com.lingyang.qaexchanger.lingyangqaexchanger.client.resp.CouponsTemplatesResp;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BaseConstants;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BusinessErrorCode;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.ICouponService;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.CouponsTemplateVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.WebHookVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.IWebhookService;
import com.lingyang.qaexchanger.lingyangqaexchanger.util.DateUtil;
import com.lingyang.qaexchanger.lingyangqaexchanger.util.JasonUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Description: 优惠券服务模块
 * @Title: CouponServiceImpl
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl
 * @Author: Jason
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 15:28
 */
@Slf4j
@Service
public class CouponServiceImpl implements ICouponService {

    @Resource
    private IWebhookService webhookService;

    @SneakyThrows
    @Override
    public void sendCoupons(List<SendCouponsDTO> sendCouponsDTOList, WebHookHeaderDTO webHookHeaderDTO, Long timestamp, String nonce) {
        if (CollectionUtils.isEmpty(sendCouponsDTOList)) {
            log.error("COUPONS_SEND, Current sendCouponsDTOList is empty! timestamp={}, nonce={}", timestamp, nonce);
            throw new BusinessException(BusinessErrorCode.ERROR_0101300, "多用户集合数据不同为空");
        }
        // Webhook发券请求的参数埋点
        log.info("COUPONS_SEND, Parameter information of current request timestamp={}, nonce={}, sendCouponsDTOList={}, webHookHeaderDTO={}."
                , timestamp, nonce, sendCouponsDTOList, webHookHeaderDTO);

        // 取集合中第一个用户数据的公共部分参数作为本次请求的外层参数
        SendCouponsDTO sendCouponsDTO = sendCouponsDTOList.get(0);
        // 发放优惠券数据传输对象
        SendCouponsProcessInfoDTO sendCouponsProcessInfoDTO = sendCouponsDTO.getProcess_info();
        // 发放优惠券webhook自定义信息
        SendCouponsParamsDTO sendCouponsParamsDTO = sendCouponsDTO.getParams();
        // 组装回调唯一标识
        String sourceId = BaseConstants.STRING_QA + sendCouponsProcessInfoDTO.getProcessNodeInstanceId();
        String unionKey = this.webhookService.initUnionKey(sendCouponsParamsDTO, webHookHeaderDTO, sourceId);
        String batchNo = webHookHeaderDTO.getProcessSchedulerId() + "-" + webHookHeaderDTO.getProcessNodeId();

        // 发券监控数据
        Map<String, String> monitorDataMap = new HashMap<>();
        // 发放用户列表通过遍历集合进行组装
        String processSchedulerId = webHookHeaderDTO.getProcessSchedulerId();
        String[] unionIdList = new String[sendCouponsDTOList.size()];
        for (int i = 0 ; i < sendCouponsDTOList.size() ; i++) {
            SendCouponsDTO bean = sendCouponsDTOList.get(i);
            SendCouponsUserProfileDTO beanSendCouponsUserProfileDTO = bean.getUser_profile();
            if (Objects.isNull(beanSendCouponsUserProfileDTO)) {
                log.info("COUPONS_SEND, Coupon issuing user information is empty! timestamp={}, nonce={}, SendCouponsDTO={}"
                        , timestamp, nonce, bean);
                continue;
            }
            String dTMillerCustomerId = beanSendCouponsUserProfileDTO.getTarget_id();
            unionIdList[i] = dTMillerCustomerId;
            // 埋点
            UnionKeyDTO unionKeyDTO = this.webhookService.parseUnionKey(unionKey);
            unionKeyDTO.setSendTime(String.valueOf(System.currentTimeMillis()));
            monitorDataMap.put(dTMillerCustomerId, JasonUtil.toJson(unionKeyDTO));
        }
        // 新建Webhook时，主动领取活动名称字段移除，业务意义赋予给旅程节点名称processNodeName
        String actName = sendCouponsParamsDTO.getAct_name();
        if (StringUtils.isNotBlank(webHookHeaderDTO.getProcessNodeName())) {
            actName = webHookHeaderDTO.getProcessNodeName();
        }

        // WebHook新增日期控件后的特殊匹配，兼容字符串传参旧场景
        String actStartTime = sendCouponsParamsDTO.getAct_start_time();
        String actEndTime = sendCouponsParamsDTO.getAct_end_time();
        try {
            actStartTime = DateUtil.formatYYYYMMDDhlingyangmss(
                    new Date(Long.parseLong(sendCouponsParamsDTO.getAct_start_time())));
            actEndTime = DateUtil.formatYYYYMMDDhlingyangmss(
                    new Date(Long.parseLong(sendCouponsParamsDTO.getAct_end_time())));
        } catch (Exception e) {
            // do not throw
        }

        SendCouponsParamReq sendCouponsParamReq = new SendCouponsParamReq();
        sendCouponsParamReq.setAct_name(actName);
        sendCouponsParamReq.setAct_start_time(actStartTime);
        sendCouponsParamReq.setAct_end_time(actEndTime);
        sendCouponsParamReq.setTemplate_id(sendCouponsParamsDTO.getTemplate_id());
        sendCouponsParamReq.setUnion_key(unionKey);
        sendCouponsParamReq.setUnion_id_list(unionIdList);
        // 批次参数会关联DTMiller活动信息，因此需要填充周期性任务ID和它的活动作一一对应
        sendCouponsParamReq.setBatch_no(batchNo);
        // 批次参数会关联DTMiller活动信息，因此需要填充周期性任务ID和它的活动作一一对应
        sendCouponsParamReq.setActivity_id(batchNo);

        // 来源参数填充某一个受众用户的节点实例ID，节点实例ID通过雪花算法获取
        sendCouponsParamReq.setSource_id(sourceId);
        // 最终的参数形式
        SendCouponsReq sendCouponsReq = new SendCouponsReq();
        sendCouponsReq.setMethod_name(sendCouponsDTO.getParams().getMethod_name());
        sendCouponsReq.setRequest_param(sendCouponsParamReq);
    }

    @Override
    public WebHookVO<CouponsTemplateVO> getCouponsTemplateVos(Long pageNumber, Integer pageSize,
                                           String searchText, Long timestamp, String nonce) throws BusinessException {
        // Webhook查询券模板请求的参数打印
        log.info("COUPONS_GET_TEMPLATE, Parameter information of current request timestamp={}, nonce={}, " +
                        "pageNumber={}, pageSize={}, searchText={}.", timestamp, nonce, pageNumber, pageSize, searchText);
        // 组装Webhook范式报文
        WebHookVO<CouponsTemplateVO> webHookVO = new WebHookVO<>();
        //业务处理过程
        // Webhook查询券模板请求的结果打印
        log.info("COUPONS_GET_TEMPLATE, Current request timestamp={}, nonce={}, result={}", timestamp, nonce, webHookVO);
        return webHookVO;
    }
}
