package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl;

import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BaseConstants;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BusinessErrorCode;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.GetTokenDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.IAuthService;
import com.lingyang.qaexchanger.lingyangqaexchanger.util.AesUtil;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.GetTokenVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.VerifyTokenVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;


/**
 * @Description: 授权服务实现类
 * @Title: AuthServiceImpl
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service.impl
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 10:57
 */
@Slf4j
@Service
public class AuthServiceImpl implements IAuthService {

    /**
     * token有效时长
     */
    @Value("${business.auth.token.validity-time}")
    private Long tokenValidityTime;

    @Override
    public GetTokenVO getToken(GetTokenDTO getTokenDTO) {
        log.info("AUTH_GET_TOKEN, Current request parameters: {}", getTokenDTO);
        Long expireTime = System.currentTimeMillis() + tokenValidityTime.longValue();

        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(getTokenDTO.getAppKey());
        strBuffer.append(BaseConstants.STRING_SPLIT);
        strBuffer.append(expireTime.longValue());

        String accessToken = null;
        try {
            accessToken = AesUtil.encryptData(strBuffer.toString());
        } catch (Exception e) {
            log.error("AUTH_GET_TOKEN, accessToken encrypt fail.", e);
            throw new BusinessException(BusinessErrorCode.ERROR_0101100, "accessToken生成失败");
        }
        GetTokenVO getTokenVO = new GetTokenVO();
        getTokenVO.setAccessToken(accessToken);
        getTokenVO.setExpireTime(expireTime);

        log.info("AUTH_GET_TOKEN, Current requestID={} response: {}", getTokenDTO.getRequestId(), getTokenVO);
        return getTokenVO;
    }

}
