package com.lingyang.qaexchanger.lingyangqaexchanger.service;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.SendCouponsParamsDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.UnionKeyDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookHeaderDTO;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description: Webhook服务类
 * @Title: IWebhookService
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/18 18:27
 */
public interface IWebhookService {

    /**
     * 解析请求头参数
     *
     * @param request
     * @return
     */
    WebHookHeaderDTO parseHeaderParam(HttpServletRequest request);

    /**
     * 解析‘回调唯一标识’中透传的webhook信息
     *
     * @param unionKey
     * @return
     */
    UnionKeyDTO parseUnionKey(String unionKey);

    /**
     * 生成‘回调唯一标识’
     *
     * @param sendCouponsParamsDTO  发放优惠券webhook自定义信息
     * @param webHookHeaderDTO  Webhook请求头信息
     * @param sourceId 来源标记
     * @return
     */
    String initUnionKey(SendCouponsParamsDTO sendCouponsParamsDTO, WebHookHeaderDTO webHookHeaderDTO, String sourceId);
}
