package com.lingyang.qaexchanger.lingyangqaexchanger.service;


import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.CommonDTO;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @Description: 签名服务
 * @Title: ISignService
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 10:51
 */
public interface ISignService {
    /**
     * 验证签名信息
     *  - 生成accessToken接口专用
     *
     * @param params 业务参数
     * @param commonDTO 公共参数
     */
    void verifyTokenSign(Map<String, String> params, CommonDTO commonDTO);

    /**
     * 验证webhook签名信息
     *
     * @param timestamp 秒级时间戳
     * @param nonce  32位随机字符串
     * @param signature webhook传递的签名信息
     * @param requestId 唯一请求标识
     */
    void verifyWebhookSign(Long timestamp, String nonce, String signature, String requestId);
}
