package com.lingyang.qaexchanger.lingyangqaexchanger.service;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.SendCouponsDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookHeaderDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.CouponsTemplateVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.WebHookVO;

import java.util.List;

/**
 * @Description: 优惠券服务模块
 * @Title: ICouponService
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.service
 * @Author: Jason
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 15:28
 */
public interface ICouponService {

    /**
     * 发放优惠券
     *
     * @param sendCouponsDTOList 发放优惠券数据传输对象
     * @param webHookHeaderDTO 请求头信息
     * @param timestamp  秒级时间戳
     * @param nonce  32位随机字符串
     *
     * @throws BusinessException 业务异常
     */
    void sendCoupons(List<SendCouponsDTO> sendCouponsDTOList, WebHookHeaderDTO webHookHeaderDTO, Long timestamp, String nonce) throws BusinessException;

    /**
     * 查询优惠券模板列表
     *
     * @param pageNumber  分页参数-页码
     * @param pageSize  分页参数-每页条数
     * @param searchText  搜索参数
     * @param timestamp  秒级时间戳
     * @param nonce  32位随机字符串
     * @return
     * @throws BusinessException 业务异常
     */
    WebHookVO<CouponsTemplateVO> getCouponsTemplateVos(Long pageNumber, Integer pageSize,
                                    String searchText, Long timestamp, String nonce) throws BusinessException;
}
