package com.lingyang.qaexchanger.lingyangqaexchanger.exception;

import lombok.Data;


/**
 * @Description: 业务异常类
 * @Title: BusinessException
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.exception
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 14:55
 */
@Data
public class BusinessException extends RuntimeException {

    private static final long serialVersionUID = 5606288089716222981L;

    private String errorMsg;

    private String errorCode;

    private Object[] errorParam;

    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String message) {
        super(message);
        this.setErrorMsg(message);
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
        this.setErrorMsg(message);
    }

    public BusinessException(String errorCode, String errorMsg, Object[] errorParam) {
        super(errorMsg);
        this.setErrorParam(errorParam);
        this.setErrorCode(errorCode);
        this.setErrorMsg(errorMsg);
    }

    public BusinessException(String errorCode, String errorMsg) {
        super(errorMsg);
        this.setErrorCode(errorCode);
        this.setErrorMsg(errorMsg);
    }

}
