package com.lingyang.qaexchanger.lingyangqaexchanger.controller;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.ICouponClient;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.SendCouponsDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookBodyDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookHeaderDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.response.ResultResponse;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.ICouponService;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.ISignService;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.CouponsTemplateVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.WebHookVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.IWebhookService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Description: 优惠券服务模块
 * @Title: CouponController
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.controller
 * @Author: Jason
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 15:28
 */
@Slf4j
@RestController
public class CouponController implements ICouponClient {

    @Resource
    private ISignService signService;

    @Resource
    private IWebhookService webhookService;

    @Resource
    private ICouponService couponService;

    @Override
    public ResultResponse sendCoupons(Long timestamp, String nonce, String signature, List<SendCouponsDTO> sendCouponsDTOList,
                                      HttpServletRequest request) {
        try {
            // 签名验证
            this.signService.verifyWebhookSign(timestamp, nonce, signature, nonce);
            // 获取请求头信息
            WebHookHeaderDTO webHookHeaderDTO = this.webhookService.parseHeaderParam(request);
            // 发放优惠券
            this.couponService.sendCoupons(sendCouponsDTOList, webHookHeaderDTO, timestamp, nonce);
            return ResultResponse.successWebhookResult(nonce);
        } catch (BusinessException e) {
            log.error("COUPONS_SEND, invoke sendCoupons Exception fail, sendCouponsDTOList="+sendCouponsDTOList, e);
            return ResultResponse.errorResult(nonce, e.getErrorCode());
        } catch (Exception e) {
            log.error("COUPONS_SEND, invoke sendCoupons Exception fail, sendCouponsDTOList="+sendCouponsDTOList, e);
            return ResultResponse.errorResult(nonce);
        }
    }

    @Override
    public WebHookVO<CouponsTemplateVO> getCouponsTemplate(Long timestamp, String nonce, Long pageNumber,
                                           Integer pageSize, String searchText, String signature, WebHookBodyDTO webHookBodyDTO) {
        try {
            // 签名验证
            this.signService.verifyWebhookSign(timestamp, nonce, signature, nonce);
            // 查询优惠券模板
            return this.couponService.getCouponsTemplateVos(pageNumber, pageSize, searchText, timestamp, nonce);
        } catch (BusinessException e) {
            log.error("COUPONS_GET_TEMPLATE, invoke getCouponsTemplate Exception fail, webHookBodyDTO="+webHookBodyDTO, e);
            return new WebHookVO<>();
        } catch (Exception e) {
            log.error("COUPONS_GET_TEMPLATE, invoke getCouponsTemplate Exception fail, webHookBodyDTO="+webHookBodyDTO, e);
            return new WebHookVO<>();
        }
    }

}
