package com.lingyang.qaexchanger.lingyangqaexchanger.controller;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.IAuthClient;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BaseConstants;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.GetTokenDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.response.ResultResponse;
import com.lingyang.qaexchanger.lingyangqaexchanger.exception.BusinessException;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.IAuthService;
import com.lingyang.qaexchanger.lingyangqaexchanger.service.ISignService;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.GetTokenVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: 授权服务
 * @Title: AuthController
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.controller
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 11:29
 */
@Slf4j
@RestController
public class AuthController implements IAuthClient {

    @Resource
    ISignService signService;

    @Resource
    IAuthService authService;

    @Override
    public ResultResponse<GetTokenVO> getToken(GetTokenDTO getTokenDTO) {
        try {
            Map<String, String> params = new HashMap<>();
            params.put("appKey", getTokenDTO.getAppKey());
            params.put(BaseConstants.SIGN_REQUEST_ID, getTokenDTO.getRequestId());
            params.put(BaseConstants.SIGN_METHOD, getTokenDTO.getSignMethod());
            params.put(BaseConstants.SIGN_TIMESTAMP, String.valueOf(getTokenDTO.getTimestamp()));
            // 签名验证
            this.signService.verifyTokenSign(params, getTokenDTO);
            // 生成凭证
            GetTokenVO getTokenVO = this.authService.getToken(getTokenDTO);
            return ResultResponse.successResult(getTokenDTO.getRequestId(), getTokenVO);
        } catch (BusinessException e) {
            log.error("AUTH_GET_TOKEN, invoke auth getToken Exception fail, getTokenDTO="+getTokenDTO, e);
            return ResultResponse.errorResult(getTokenDTO.getRequestId(), e.getErrorCode());
        } catch (Exception e) {
            log.error("AUTH_GET_TOKEN, invoke auth getToken Exception fail, getTokenDTO="+getTokenDTO, e);
            return ResultResponse.errorResult(getTokenDTO.getRequestId());
        }
    }
}
