package com.lingyang.qaexchanger.lingyangqaexchanger.constants;

/**
 * @Description: 业务错误代码
 * @Title: BusinessErrorCode
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.constants
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 11:38
 */
public class BusinessErrorCode {

    /**
     * 公共错误代码
     */
    public static final String ERROR_0100001 = "0100001"; // 系统错误
    public static final String ERROR_0100002 = "0100002"; // 请检查请求入参是否规范
    public static final String ERROR_0100003 = "0100003"; // 参数不全
    public static final String ERROR_0100004 = "0100004"; // 幂等

    /**
     * 签名模块
     */
    public static final String ERROR_0101001 = "0101001"; // 签名错误
    public static final String ERROR_0101002 = "0101002"; // 无效的appKey
    public static final String ERROR_0101003 = "0101003"; // 签名验证失败
    public static final String ERROR_0101004 = "0101004"; // DTMiller签名生成失败

    /**
     * 授权模块
     */
    public static final String ERROR_0101100 = "0101100"; // accessToken生成失败
    public static final String ERROR_0101101 = "0101101"; // Authorization failed!(The credential cannot be blank)
    public static final String ERROR_0101102 = "0101102"; // Authorization failed!(The credential is NOT acceptable)


    /**
     * 电子劵模板模块
     */
    public static final String ERROR_0101200 = "0101200"; // 签名错误
    public static final String ERROR_0101201 = "0101201"; // 查询优惠券模板信息失败
    public static final String ERROR_0101202 = "0101202"; // 查询优惠券模板信息结果不合法

    /**
     * 发放电子劵模块
     */
    public static final String ERROR_0101300 = "0101300"; // 多用户集合数据不同为空
    public static final String ERROR_0101301 = "0101301"; // 发送优惠券时解析参数失败
    public static final String ERROR_0101302 = "0101302"; // 发送优惠券失败
    public static final String ERROR_0101303 = "0101303"; // 发送优惠券结果不合法

    /**
     * 回执上报
     */
    public static final String ERROR_0101400 = "0101400"; // 实时回调回执上报失败
    public static final String ERROR_0101401 = "0101401"; // 实时回调回执上报结果不合法

    /**
     * 事件上报
     */
    public static final String ERROR_0101500 = "0101500"; // 无法识别的发券渠道类型
    public static final String ERROR_0101501 = "0101501"; // 事件上报失败
    public static final String ERROR_0101502 = "0101502"; // 事件上报时解析参数失败
    public static final String ERROR_0101503 = "0101503"; // 事件上报结果不合法
    public static final String ERROR_0101504 = "0101504"; // 无法识别的事件类型

    /**
     * WEBHOOK模块
     */
    public static final String ERROR_0101600 = "0101600"; // UnionKey格式不合法
}
