package com.lingyang.qaexchanger.lingyangqaexchanger.constants;

/**
 * @Description: Redis常量类
 * @Title: BaseRedisConstants
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.constants
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/28 16:41
 */
public class BaseRedisConstants {

    /**
     * 前缀标记
     */
    public static final String STR_PREFIX = "exchanger-api";
    /**
     * 分隔符
     */
    public static final String STR_SPILT = ":";

    /**
     * 缓存K生成方法
     *
     * @param keys
     * @return
     */
    public static String buildCacheRedisKey(String... keys) {
        StringBuffer redisKey = new StringBuffer(STR_PREFIX);
        for (int i = 0; i < keys.length; i++) {
            String keyItem = keys[i];
            redisKey.append(STR_SPILT).append(keyItem);
        }
        return redisKey.toString();
    }

}
