package com.lingyang.qaexchanger.lingyangqaexchanger.constants;


import org.apache.commons.lang3.StringUtils;

/**
 * @Description: 基础常量类
 * @Title: BaseConstants
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.constants
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 12:18
 */
public class BaseConstants {

    /**
     * 基础常量
     */
    public static final String STRING_SUCCESS = "success";
    public static final String STRING_0 = "0";
    public static final String STRING_OK = "OK";
    public static final String STRING_SPLIT = ":";
    public static final String STRING_SPLIT_1 = "#st#";
    public static final String STRING_Y = "Y";
    public static final String STRING_UTF8 = "UTF-8";
    public static final String STRING_QA = "QA_";
    public static final int INT_0 = 0;
    public static final int INT_2 = 2;
    public static final int INT_5 = 5;
    public static final int INT_15 = 15;
    public static final int INT_200 = 200;

    /**
     * 健康检查
     */
    public static final String HEALTH_APP_NAME = "APP_NAME";
    public static final String HEALTH_VERSION = "VERSION";
    public static final String HEALTH_TIME_MILLIS = "TIME_MILLIS";
    public static final String HEALTH_TARGET = "/target";
    public static final String HEALTH_POM = "/pom.xml";
    public static final String HEALTH_UTF8 = "UTF-8";

    /**
     * 签名常量
     */
    public static final String SIGN_UTF8 = "UTF-8";
    public static final String SIGN_UPPER_MD5 = "MD5";
    public static final String SIGN_LOWER_MD5 = "md5";
    public static final String SIGN_REQUEST_ID = "requestId";
    public static final String SIGN_METHOD = "signMethod";
    public static final String SIGN_TIMESTAMP = "timestamp";
    public static final String SIGN_HEADER_SIGNATURE = "X-QA-Hmac-Signature";

    /**
     * 鉴权常量
     */
    public static final String OAUTH_APP_KEY = "OAUTH_APP_KEY";

    /**
     * 事件类型
     */
    public static final String EVENT_USER_GET_CARD = "USER_GET_CARD";
    public static final String EVENT_USER_CONSUME_CARD = "USER_CONSUME_CARD";
    public static final String EVENT_USER_INVALIDATION_CARD = "USER_INVALIDATION_CARD";
    public static final String EVENT_MEMBER_REGISTER = "MEMBER_REGISTER";

    public static final String EVENT_CHANNEL_QA = "CHANNEL_QA";
    public static final String EVENT_CHANNEL_DT_MILLER = "CHANNEL_DTMILLER";
    public static final String EVENT_CHANNEL_THIRD_PARTY = "CHANNEL_THIRD_PARTY";
    public static final String EVENT_CHANNEL_OTHER = "CHANNEL_OTHER";

    /**
     * ID类型
     */
    public static final String ID_TYPE_ONE_ID = "oneID";
    public static final String ID_TYPE_OPEN_ID = "openID";
    public static final String ID_TYPE_MOBILE_PHONE = "mobile";

    /**
     * 系统主动发券方式
     */
    public static final String METHOD_NAME_SEND = "send";

    /**
     * 是否为用户卡券领取事件
     *
     * @param eventType
     * @return
     */
    public static final boolean isUserGetCardEvent(String eventType) {
        return StringUtils.equalsIgnoreCase(EVENT_USER_GET_CARD, eventType);
    }

    /**
     * 是否为用户卡券核销事件
     *
     * @param eventType
     * @return
     */
    public static final boolean isUserConsumeCardEvent(String eventType) {
        return StringUtils.equalsIgnoreCase(EVENT_USER_CONSUME_CARD, eventType);
    }

    /**
     * 是否为用户卡券无效事件
     *
     * @param eventType
     * @return
     */
    public static final boolean isUserInvalidationCard(String eventType) {
        return StringUtils.equalsIgnoreCase(EVENT_USER_INVALIDATION_CARD, eventType);
    }


    /**
     * 是否会员注册事件
     *
     * @param eventType
     * @return
     */
    public static final boolean isMemberRegister(String eventType) {
        return StringUtils.equalsIgnoreCase(EVENT_MEMBER_REGISTER, eventType);
    }


    /**
     * 是否QA发券渠道
     *
     * @param issueChannel
     * @return
     */
    public static final boolean isQaIssueChannel(String issueChannel) {
        return StringUtils.equalsIgnoreCase(BaseConstants.EVENT_CHANNEL_QA, issueChannel);
    }
}
