package com.lingyang.qaexchanger.lingyangqaexchanger.client.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Description: 查询优惠券模板列表响应对象
 * @Title: CouponsTemplatesResp
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.client.resp
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/16 17:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "查询优惠券模板列表响应对象")
public class CouponsTemplatesResp {

    @ApiModelProperty(value = "模板列表", required = true, example = "List")
    private List<CouponsTemplateResp> list;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    private Integer page_no;

    @ApiModelProperty(value = "每页条数", required = true, example = "10")
    private Integer page_size;

    @ApiModelProperty(value = "总页数", required = true, example = "61")
    private Integer pages;

    @ApiModelProperty(value = "自定义参数", required = true, example = "Object")
    private Object params;

    @ApiModelProperty(value = "总条数", required = true, example = "608")
    private Integer total;

}
