package com.lingyang.qaexchanger.lingyangqaexchanger.client.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Arrays;

/**
 * @Description: 发放优惠券参数传输对象
 * @Title: SendCouponsParamReq
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.client.req
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/12 20:13
 */
@Data
public class SendCouponsParamReq {

    @ApiModelProperty(value = "用户unionId 列表，最大500条", required = true, example = "Array")
    private String[] union_id_list;

    @ApiModelProperty(value = "回调唯一标识", required = true, example = "AA:BB:CC")
    private String union_key;

    @ApiModelProperty(value = "优惠券模板ID", required = true, example = "245")
    private String template_id;

    @ApiModelProperty(value = "来源ID", required = true, example = "111")
    private String source_id;

    @ApiModelProperty(value = "主动领取活动名称", required = true, example = "领取活动名称")
    private String act_name;

    @ApiModelProperty(value = "主动领取批次标识", required = true, example = "12334")
    private String batch_no;

    @ApiModelProperty(value = "主动领取活动开始时间", required = true, example = "2022-04-01 00:00:00")
    private String act_start_time;

    @ApiModelProperty(value = "主动领取活动结束时间", required = true, example = "2022-04-02 00:00:00")
    private String act_end_time;

    @ApiModelProperty(value = "主动领取活动唯一标识，活动id会在crm生成一个唯一的主动 领取活动", required = true, example = "1234")
    private String activity_id;


    @Override
    public String toString() {
        return "SendCouponsParamReq{" +
                "union_id_list=" + Arrays.toString(union_id_list) +
                ", union_key='" + union_key + '\'' +
                ", template_id='" + template_id + '\'' +
                ", source_id='" + source_id + '\'' +
                ", act_name='" + act_name + '\'' +
                ", batch_no='" + batch_no + '\'' +
                ", act_start_time='" + act_start_time + '\'' +
                ", act_end_time='" + act_end_time + '\'' +
                ", activity_id='" + activity_id + '\'' +
                '}';
    }
}
