package com.lingyang.qaexchanger.lingyangqaexchanger.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 凭证信息返回对象
 * @Title: GetTokenVO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.dto.vo
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 10:59
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "凭证信息返回对象")
public class GetTokenVO {

    @ApiModelProperty(value = "授权凭证", required = true, example = "xxxx")
    private String accessToken;

    @ApiModelProperty(value = "过期时间", required = true, example = "1651807193012")
    private Long expireTime;

    @Override
    public String toString() {
        return "GetTokenVO{" +
                "accessToken='" + accessToken + '\'' +
                ", expireTime=" + expireTime +
                '}';
    }
}
