package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.response;

import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BaseConstants;
import com.lingyang.qaexchanger.lingyangqaexchanger.constants.BusinessErrorCode;
import com.lingyang.qaexchanger.lingyangqaexchanger.util.PropsUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import java.util.UUID;

/**
 * @Description: 标准返回对象类
 * @Title: ResultResponse
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.dto.response
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 15:34
 */
@ApiModel("标准返回")
@Data
public class ResultResponse<T> {

    @ApiModelProperty(value = "请求唯一标识", example = "90fc571bac204546bed023000508a6d5")
    private String requestId;

    @ApiModelProperty(value = "业务错误码", example = "AA-BB-CCC")
    private String code;

    @ApiModelProperty(value = "额外消息", example = "Parameters cannot be null")
    private String message;

    @ApiModelProperty(value = "是否成功", example = "true")
    private Boolean success;

    @ApiModelProperty(value = "业务数据", example = "object[xx=yy]")
    private T Data;

    /**
     * 构造方法
     */
    public ResultResponse() {
        this.requestId = UUID.randomUUID().toString();
    }

    /**
     * 成功返回调用
     *
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> successResult() {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setCode(BaseConstants.STRING_0);
        resultResponse.setSuccess(true);
        resultResponse.setMessage(BaseConstants.STRING_SUCCESS);
        return resultResponse;
    }

    /**
     * 成功返回调用
     *
     * @param requestId 请求唯一标识
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> successResult(String requestId) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(BaseConstants.STRING_0);
        resultResponse.setSuccess(true);
        resultResponse.setMessage(BaseConstants.STRING_SUCCESS);
        return resultResponse;
    }

    /**
     * 成功返回调用
     *
     * @param data 业务数据
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> successResult(T data) {
        ResultResponse<T> resultDTO = new ResultResponse();
        resultDTO.setCode(BaseConstants.STRING_0);
        resultDTO.setSuccess(true);
        resultDTO.setMessage(BaseConstants.STRING_SUCCESS);
        resultDTO.setData(data);
        return resultDTO;
    }

    /**
     * 成功返回调用
     *
     * @param requestId 请求唯一标识
     * @param data 业务数据
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> successResult(String requestId, T data) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(BaseConstants.STRING_0);
        resultResponse.setSuccess(true);
        resultResponse.setMessage(BaseConstants.STRING_SUCCESS);
        resultResponse.setData(data);
        return resultResponse;
    }

    /**
     * 成功返回调用
     *
     * @param requestId 请求唯一标识
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> successWebhookResult(String requestId) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(BaseConstants.STRING_OK);
        resultResponse.setSuccess(true);
        resultResponse.setMessage(BaseConstants.STRING_SUCCESS);
        return resultResponse;
    }

    /**
     * 失败返回调用
     *
     * @param requestId 请求唯一标识
     * @param code 业务错误码
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> errorResult(String requestId, String code) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(code);
        resultResponse.setMessage(PropsUtil.getProperty(code));
        resultResponse.setSuccess(false);
        return resultResponse;
    }

    /**
     * 失败返回调用
     *
     * @param requestId 请求唯一标识
     * @param code 业务错误码
     * @param message 额外消息
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> errorResult(String requestId, String code, String message) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(code);
        resultResponse.setMessage(message);
        resultResponse.setSuccess(false);
        return resultResponse;
    }

    /**
     * 失败返回调用
     *
     * @param requestId 请求唯一标识
     * @param code 业务错误码
     * @param message 额外消息
     * @param data 业务数据
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> errorResult(String requestId, String code, String message, T data) {
        ResultResponse<T> resultResponse = new ResultResponse();
        resultResponse.setRequestId(requestId);
        resultResponse.setCode(code);
        resultResponse.setMessage(message);
        resultResponse.setSuccess(false);
        resultResponse.setData(data);
        return resultResponse;
    }

    /**
     * 失败返回调用
     *
     * @param requestId 请求唯一标识
     * @param <T> 泛型
     * @return 标准返回对象
     */
    public static <T> ResultResponse<T> errorResult(String requestId) {
        return errorResult(requestId, BusinessErrorCode.ERROR_0100001);
    }
}
