package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: Webhook请求头信息
 * @Title: WebHookHeaderDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/18 18:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@ApiModel(value = "Webhook请求头信息")
public class WebHookHeaderDTO {

    @ApiModelProperty(value = "旅程ID", example = "1917810")
    private String processId;

    @ApiModelProperty(value = "旅程名称", example = "1917810")
    private String processName;

    @ApiModelProperty(value = "旅程每次周期调度ID", example = "1917810")
    private String processSchedulerId;

    @ApiModelProperty(value = "旅程每次周期调度的名称(旅程ID+周期的时间拼接字符串)", example = "1917810")
    private String processSchedulerName;

    @ApiModelProperty(value = "旅程周期开始时间，时间戳格式", example = "1917810")
    private String processSchedulerStartTime;

    @ApiModelProperty(value = "旅程节点ID(每个周期的节点ID都是⼀样的)", example = "1917810")
    private String processNodeId;

    @ApiModelProperty(value = "旅程节点名称(每个周期的节点名称都是⼀样的)", example = "1917810")
    private String processNodeName;

    @ApiModelProperty(value = "营销⽇历活动ID", example = "1917810")
    private String activityId;

    @ApiModelProperty(value = "营销⽇历活动名称", example = "1917810")
    private String activityName;

    @ApiModelProperty(value = "营销⽇历⼦活动ID", example = "1917810")
    private String subActivityId;

    @ApiModelProperty(value = "营销⽇历⼦活动名称", example = "1917810")
    private String subActivityName;



    @ApiModelProperty(value = "幂等批次号", example = "NA")
    private String batchId;


    @Deprecated
    @ApiModelProperty(value = "废弃#等于processId推荐⽤processId", example = "NA")
    private String jobId;

    @Deprecated
    @ApiModelProperty(value = "废弃#等于processName#推荐⽤processName", example = "NA")
    private String jobName;

    @Deprecated
    @ApiModelProperty(value = "废弃#等于processNodeId#推荐⽤processNodeId", example = "NA")
    private String nodeId;

    @Deprecated
    @ApiModelProperty(value = "废弃#等于processNodeName#推荐⽤processNodeName", example = "NA")
    private String nodeName;

    @Deprecated
    @ApiModelProperty(value = "废弃#等于processNodeName#推荐⽤processNodeName", example = "NA")
    private String taskId;



    @Deprecated
    @ApiModelProperty(value = "废弃#等于processSchedulerStartTime#是时间戳格式#推荐⽤processSchedulerStartTime", example = "NA")
    private String taskStartTimestamp;

    @Deprecated
    @ApiModelProperty(value = "废弃#等于processSchedulerStartTime#是时间戳格式#推荐⽤processSchedulerStartTime", example = "NA")
    private String nodeStartTimestamp;

    @Deprecated
    @ApiModelProperty(value = "废弃#兼容⽼版本#等于processSchedulerId", example = "NA")
    private String processInstanceId;

    @Deprecated
    @ApiModelProperty(value = "废弃#兼容⽼版本#等于processSchedulerName", example = "NA")
    private String processInstanceName;

    @Deprecated
    @ApiModelProperty(value = "废弃#兼容⽼版本#等于processSchedulerStartTime", example = "NA")
    private String processInstanceStartTime;

    @Override
    public String toString() {
        return "WebHookHeaderDTO{" +
                "processId='" + processId + '\'' +
                ", processName='" + processName + '\'' +
                ", processSchedulerId='" + processSchedulerId + '\'' +
                ", processSchedulerName='" + processSchedulerName + '\'' +
                ", processSchedulerStartTime='" + processSchedulerStartTime + '\'' +
                ", processNodeId='" + processNodeId + '\'' +
                ", processNodeName='" + processNodeName + '\'' +
                ", activityId='" + activityId + '\'' +
                ", activityName='" + activityName + '\'' +
                ", subActivityId='" + subActivityId + '\'' +
                ", subActivityName='" + subActivityName + '\'' +
                ", jobId='" + jobId + '\'' +
                ", jobName='" + jobName + '\'' +
                ", nodeId='" + nodeId + '\'' +
                ", nodeName='" + nodeName + '\'' +
                ", taskId='" + taskId + '\'' +
                ", batchId='" + batchId + '\'' +
                ", taskStartTimestamp='" + taskStartTimestamp + '\'' +
                ", nodeStartTimestamp='" + nodeStartTimestamp + '\'' +
                ", processInstanceId='" + processInstanceId + '\'' +
                ", processInstanceName='" + processInstanceName + '\'' +
                ", processInstanceStartTime='" + processInstanceStartTime + '\'' +
                '}';
    }
}
