package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 回调标识
 * @Title: UnionKeyDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/19 18:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@ApiModel(value = "回调标识")
public class UnionKeyDTO {

    @ApiModelProperty(value = "旅程ID", example = "1917810")
    private String processId;

    @ApiModelProperty(value = "旅程名称", example = "1917810")
    private String processName;

    @ApiModelProperty(value = "旅程节点ID(每个周期的节点ID都是⼀样的)", example = "1917810")
    private String processNodeId;

    @ApiModelProperty(value = "旅程节点名称(每个周期的节点ID都是⼀样的)", example = "1917810")
    private String processNodeName;

    @ApiModelProperty(value = "旅程每次周期调度ID", example = "1917810")
    private String processSchedulerId;

    @ApiModelProperty(value = "旅程每次周期调度的名称(旅程ID+周期的时间拼接字符串)", example = "1917810")
    private String processSchedulerName;

    @ApiModelProperty(value = "模板ID", example = "429")
    private String templateId;

    @ApiModelProperty(value = "调用方法,send:系统主动发,receive:用户主动领", example = "receive")
    private String methodName;

    @ApiModelProperty(value = "来源ID", example = "aabbcc")
    private String sourceId;

    @ApiModelProperty(value = "随机串", example = "aabbcc")
    private String batchId;

    @ApiModelProperty(value = "发送时间", example = "aabbcc")
    private String sendTime;

    @Override
    public String toString() {
        return "UnionKeyDTO{" +
                "processId='" + processId + '\'' +
                ", processName='" + processName + '\'' +
                ", processNodeId='" + processNodeId + '\'' +
                ", processNodeName='" + processNodeName + '\'' +
                ", processSchedulerId='" + processSchedulerId + '\'' +
                ", processSchedulerName='" + processSchedulerName + '\'' +
                ", templateId='" + templateId + '\'' +
                ", methodName='" + methodName + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", batchId='" + batchId + '\'' +
                ", sendTime='" + sendTime + '\'' +
                '}';
    }
}
