package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 发放优惠券用户KV信息
 * @Title: SendCouponsUserProfileDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/12 17:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "发放优惠券用户KV信息")
public class SendCouponsUserProfileDTO {

    @ApiModelProperty(value = "目标用户ID", required = true, example = "1917810")
    @NotBlank(message = "Parameters cannot be null")
    private String target_id;

    @ApiModelProperty(value = "目标用户ID类型", required = true, example = "OPEN_ID")
    @NotBlank(message = "Parameters cannot be null")
    private String target_type;

    @ApiModelProperty(value = "产品侧客户唯⼀标识，如果上报事件需要使⽤这个ID", required = true, example = "3444433222333")
    @NotBlank(message = "Parameters cannot be null")
    private String customer_id;

    @Override
    public String toString() {
        return "SendCouponsUserProfileDTO{" +
                "target_id='" + target_id + '\'' +
                ", target_type='" + target_type + '\'' +
                ", customer_id='" + customer_id + '\'' +
                '}';
    }
}
