package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 发放优惠券旅程信息
 * @Title: SendCouponsProcessInfoDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/18 14:52
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "发放优惠券旅程信息")
public class SendCouponsProcessInfoDTO {

    @ApiModelProperty(value = "新版：旅程周期中，每个⽤户的旅程实例ID", required = true, example = "1")
    @NotBlank(message = "Parameters cannot be null")
    private String processInstanceId;

    @ApiModelProperty(value = "新版：旅程周期中，每个⽤户的旅程实例开始时间，时间戳格式", required = true, example = "2")
    @NotBlank(message = "Parameters cannot be null")
    private String processInstanceStartTime;

    @ApiModelProperty(value = "新版：旅程节点实例ID（每次不同）", required = true, example = "3")
    @NotBlank(message = "Parameters cannot be null")
    private String processNodeInstanceId;

    @ApiModelProperty(value = "新版：旅程周期中，每个⽤户的旅程的\n" +
            "节点实例开始时间，时间戳格式", required = true, example = "4")
    @NotBlank(message = "Parameters cannot be null")
    private String processNodeInstanceStartTime;

    @ApiModelProperty(value = "新版：分组ID", required = true, example = "5")
    @NotBlank(message = "Parameters cannot be null")
    private String groupId;

    @ApiModelProperty(value = "新版：分组名称", required = true, example = "6")
    @NotBlank(message = "Parameters cannot be null")
    private String groupName;

    @Override
    public String toString() {
        return "SendCouponsProcessInfoDTO{" +
                "processInstanceId='" + processInstanceId + '\'' +
                ", processInstanceStartTime='" + processInstanceStartTime + '\'' +
                ", processNodeInstanceId='" + processNodeInstanceId + '\'' +
                ", processNodeInstanceStartTime='" + processNodeInstanceStartTime + '\'' +
                ", groupId='" + groupId + '\'' +
                ", groupName='" + groupName + '\'' +
                '}';
    }
}
