package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 发放优惠券webhook自定义信息
 * @Title: SendCouponsParamsDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/12 17:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "发放优惠券webhook自定义信息")
public class SendCouponsParamsDTO {

    @ApiModelProperty(value = "调用方法,send:系统主动发,receive:用户主动领", required = true, example = "receive")
    @NotBlank(message = "Parameters cannot be null")
    private String method_name;

    @ApiModelProperty(value = "优惠券模板ID", required = true, example = "245")
    @NotBlank(message = "Parameters cannot be null")
    private String template_id;

    @ApiModelProperty(value = "主动领取活动名称", required = true, example = "领取活动名称")
    private String act_name;

    @ApiModelProperty(value = "主动领取批次标识", required = true, example = "12334")
    private String batch_no;

    @ApiModelProperty(value = "主动领取活动开始时间", required = true, example = "2022-04-01 00:00:00")
    private String act_start_time;

    @ApiModelProperty(value = "主动领取活动结束时间", required = true, example = "2022-04-02 00:00:00")
    private String act_end_time;

    @Override
    public String toString() {
        return "SendCouponsParamsDTO{" +
                "method_name='" + method_name + '\'' +
                ", template_id='" + template_id + '\'' +
                ", act_name='" + act_name + '\'' +
                ", batch_no='" + batch_no + '\'' +
                ", act_start_time='" + act_start_time + '\'' +
                ", act_end_time='" + act_end_time + '\'' +
                '}';
    }
}
