package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 发放优惠券数据传输对象
 * @Title: SendCouponsDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/12 17:05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "发放优惠券数据传输对象")
public class SendCouponsDTO {

    @ApiModelProperty(value = "发放优惠券用户KV信息", required = true, example = "object")
    private SendCouponsUserProfileDTO user_profile;

    @ApiModelProperty(value = "发放优惠券webhook自定义信息", required = true, example = "object")
    private SendCouponsParamsDTO params;

    @ApiModelProperty(value = "发放优惠券回执上报信息", required = true, example = "object")
    private SendCouponsCallbackParamDTO callback_params;

    @ApiModelProperty(value = "发放优惠券旅程信息", required = true, example = "object")
    private SendCouponsProcessInfoDTO process_info;

    @Override
    public String toString() {
        return "SendCouponsDTO{" +
                "user_profile=" + user_profile +
                ", params=" + params +
                ", callback_params=" + callback_params +
                ", process_info=" + process_info +
                '}';
    }
}
