package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 发放优惠券回执上报信息
 * @Title: SendCouponsCallbackParamDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/12 18:12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "发放优惠券回执上报信息")
public class SendCouponsCallbackParamDTO {

    @ApiModelProperty(value = "任务标识", required = true, example = "2e6eceb5737b473284c930c8ef79090e")
    @NotBlank(message = "Parameters cannot be null")
    private String task_id;

    @ApiModelProperty(value = "webhook标识", required = true, example = "13312313")
    @NotBlank(message = "Parameters cannot be null")
    private String webhook_id;

    @ApiModelProperty(value = "毫秒级时间戳", required = true, example = "1625037472000")
    @NotBlank(message = "Parameters cannot be null")
    private String send_time;

    @ApiModelProperty(value = "节点ID", required = true, example = "xxxx")
    @NotBlank(message = "Parameters cannot be null")
    private String nodeId;

    @ApiModelProperty(value = "实例ID", required = true, example = "xxxx")
    @NotBlank(message = "Parameters cannot be null")
    private String instanceId;

    @ApiModelProperty(value = "执行动作实例ID", required = true, example = "xxxx")
    @NotBlank(message = "Parameters cannot be null")
    private String actionId;

    @ApiModelProperty(value = "用户ID", required = true, example = "xxxx")
    @NotBlank(message = "Parameters cannot be null")
    private String customerId;

    @Override
    public String toString() {
        return "SendCouponsCallbackParamDTO{" +
                "task_id='" + task_id + '\'' +
                ", webhook_id='" + webhook_id + '\'' +
                ", send_time='" + send_time + '\'' +
                ", nodeId='" + nodeId + '\'' +
                ", instanceId='" + instanceId + '\'' +
                ", actionId='" + actionId + '\'' +
                ", customerId='" + customerId + '\'' +
                '}';
    }
}
