package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 凭证信息请求对象
 * @Title: GetTokenDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 11:13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "凭证信息请求对象")
public class GetTokenDTO extends CommonDTO {

    @ApiModelProperty(value = "应用appKey", required = true, example = "dtmiller")
    @NotBlank(message = "Parameters cannot be null")
    private String appKey;

    @Override
    public String toString() {
        return "GetTokenDTO{" +
                "requestId='" + this.getRequestId() + '\'' +
                " ,sign='" + this.getSign() + '\'' +
                " ,signMethod='" + this.getSignMethod() + '\'' +
                " ,timestamp='" + this.getTimestamp() + '\'' +
                " ,appKey='" + appKey + '\'' +
                '}';
    }
}
