package com.lingyang.qaexchanger.lingyangqaexchanger.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 请求参数传输对象的父类
 * @Title: CommonDTO
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.dto
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 14:19
 */
@Data
public class CommonDTO {

    @ApiModelProperty(value = "请求唯一标识", required = true, example = "90fc571bac204546bed023000508a6d5")
    @NotBlank(message = "Parameters cannot be null")
    private String requestId;

    @ApiModelProperty(value = "签名结果信息", required = true, example = "8A6D5316A3DB494D875778695DE7371C")
    @NotBlank(message = "Parameters cannot be null")
    private String sign;

    @ApiModelProperty(value = "签名摘要算法", required = true, example = "md5")
    @NotBlank(message = "Parameters cannot be null")
    private String signMethod;

    @ApiModelProperty(value = "签名的时间戳", required = true, example = "1651807193012")
    private Long timestamp;

}
