package com.lingyang.qaexchanger.lingyangqaexchanger.api;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.SendCouponsDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.WebHookBodyDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.response.ResultResponse;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.CouponsTemplateVO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.WebHookVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Description: 优惠券服务模块
 * @Title: ICouponClient
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/7 12:11
 */
@Api(tags = {"优惠券模块：Coupon"})
public interface ICouponClient {

    /**
     * 发放优惠券
     *
     * @param timestamp  秒级时间戳
     * @param nonce  32位随机字符串
     * @param signature  签名信息
     * @param sendCouponsDTOList  业务参数
     * @param request http请求对象
     * @return
     */
    @ApiOperation(value = "发放优惠券", httpMethod = "POST")
    @PostMapping(path = "/api/coupons/send", produces = MediaType.APPLICATION_JSON_VALUE)
    ResultResponse sendCoupons(@ApiParam(value = "秒级时间戳", required = true) @RequestParam("timestamp") Long timestamp,
                               @ApiParam(value = "32位随机字符串", required = true) @RequestParam("nonce") String nonce,
                               @ApiParam(value = "签名信息", required = true) @RequestHeader("X-QA-Hmac-Signature") String signature,
                               @RequestBody @Validated List<SendCouponsDTO> sendCouponsDTOList,
                               HttpServletRequest request);

    /**
     * 查询优惠券模板列表
     *
     * @param timestamp  秒级时间戳
     * @param nonce  32位随机字符串
     * @param pageNumber 分页参数-页码
     * @param pageSize 分页参数-每页条数
     * @param searchText 搜索参数
     * @param signature  签名信息
     * @param webHookBodyDTO 业务参数
     * @return
     */
    @ApiOperation(value = "查询优惠券模板列表", httpMethod = "POST")
    @PostMapping(path = "/api/coupons/get-template", produces = MediaType.APPLICATION_JSON_VALUE)
    WebHookVO<CouponsTemplateVO> getCouponsTemplate(@ApiParam(value = "秒级时间戳", required = true) @RequestParam("timestamp") Long timestamp,
                                    @ApiParam(value = "32位随机字符串", required = true) @RequestParam("nonce") String nonce,
                                    @ApiParam(value = "分页参数-页码", required = true) @RequestParam("pn") Long pageNumber,
                                    @ApiParam(value = "分页参数-每页条数", required = true) @RequestParam("ps") Integer pageSize,
                                    @ApiParam(value = "搜索参数") @RequestParam(value = "searchText", required = false) String searchText,
                                    @ApiParam(value = "签名信息", required = true) @RequestHeader("X-QA-Hmac-Signature") String signature,
                                    @RequestBody @Validated WebHookBodyDTO webHookBodyDTO);

}
