package com.lingyang.qaexchanger.lingyangqaexchanger.api;

import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.GetTokenDTO;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.dto.response.ResultResponse;
import com.lingyang.qaexchanger.lingyangqaexchanger.api.vo.GetTokenVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description: 授权服务
 * @Title: IAuthClient
 * @Package com.lingyang.qaexchanger.lingyangqaexchanger.api
 * @Author: Levi
 * @Copyright Lingyang
 * @CreateTime: 2022/5/9 11:26
 */
@Api(tags = {"授权服务：Auth"})
public interface IAuthClient {

    /**
     * 生成AccessToken接口
     *
     * @param getTokenDTO 凭证信息请求对象
     * @return
     */
    @ApiOperation(value = "生成AccessToken接口", httpMethod = "POST")
    @PostMapping(path = "/api/auth/get-token", produces = MediaType.APPLICATION_JSON_VALUE)
    ResultResponse<GetTokenVO> getToken(@RequestBody GetTokenDTO getTokenDTO);

}
