#!/bin/bash
set -u

echo "Xcodeplugin 5.9.0"
echo "Build for Apple clang (clang-1500.0.40.1)"
echo
echo "For more infomation, please visit:"
echo "  https://yuque.antfin-inc.com/obfuscator/obfuscator/installation-xcode"
echo

DIR=$(
  cd "$(dirname "$0")"
  pwd
)

XCODE=$(xcode-select -p) || {
  echo "Error: Xcode not found."
  exit 1
}

XCODE_BIN="${XCODE}/Toolchains/XcodeDefault.xctoolchain/usr/bin"
if [ ! -f "${XCODE_BIN}/clang" ]; then
  XCODE_BIN="${XCODE}/usr/bin"
fi

XCODE_CLANG_VER=$("${XCODE_BIN}/clang" -v 2>&1 | head -n 1 | awk '{print $5}') || {
  echo "Error: Unknow Apple clang version."
  exit 1
}

echo "Target:"
echo "  ${XCODE_BIN}/clang"
echo

echo "Before:"
echo "  $("${XCODE_BIN}/clang" -v 2>&1 | head -n 1)"
echo

if [ -f "${XCODE_BIN}/clang.bak" ]; then
  echo "Error: please uninstall the existing version."
  exit 1
fi

if [[ ! "(clang-1500.0.40.1)" =~ "${XCODE_CLANG_VER}" ]]; then
  echo "Error: May not compatible with Apple clang ${XCODE_CLANG_VER}."
  exit 1
fi

echo "Installing..."
echo
sudo xattr -d com.apple.quarantine "${DIR}/insertdylib" 2>/dev/null
sudo xattr -d com.apple.quarantine "${DIR}/libPluginCore.dylib" 2>/dev/null
sudo xattr -d com.apple.quarantine "${DIR}/libPlugin.dylib" 2>/dev/null

sudo mv "${XCODE_BIN}/clang" "${XCODE_BIN}/clang.bak"
sudo chmod +rx "${DIR}/insertdylib"
sudo "${DIR}/insertdylib" @executable_path/libPluginCore.dylib "${XCODE_BIN}/clang.bak" "${XCODE_BIN}/clang.tmp" --strip-codesig
sudo "${DIR}/insertdylib" @executable_path/libPlugin.dylib "${XCODE_BIN}/clang.tmp" "${XCODE_BIN}/clang" --strip-codesig
sudo rm "${XCODE_BIN}/clang.tmp"
sudo chmod +rx "${DIR}/libPluginCore.dylib"
sudo chmod +rx "${DIR}/libPlugin.dylib"
sudo cp "${DIR}/libPluginCore.dylib" "${XCODE_BIN}/"
sudo cp "${DIR}/libPlugin.dylib" "${XCODE_BIN}/"
echo

sudo codesign --force --deep --sign - "${XCODE_BIN}/clang"
sudo codesign --force --deep --sign - "${XCODE_BIN}/libPluginCore.dylib"
sudo codesign --force --deep --sign - "${XCODE_BIN}/libPlugin.dylib"

echo "After:"
echo "  $("${XCODE_BIN}/clang" -v 2>&1 | head -n 1)"
echo

echo "Predefined:"
"${XCODE_BIN}/clang" -E -dM - </dev/null | grep obfuscator || {
  echo "Error: Unknow error."
  exit 1
}
echo

echo "Done."
