#!/bin/bash
set -u

echo "Xcodeplugin 5.9.0"
echo "Build for Apple clang (clang-1500.0.40.1)"
echo
echo "For more infomation, please visit:"
echo "  https://yuque.antfin-inc.com/obfuscator/obfuscator/installation-xcode"
echo

XCODE=$(xcode-select -p) || {
  echo "Error: Xcode not found."
  exit 1
}

XCODE_BIN="${XCODE}/Toolchains/XcodeDefault.xctoolchain/usr/bin"
if [ ! -f "${XCODE_BIN}/clang" ]; then
  XCODE_BIN="${XCODE}/usr/bin"
fi

echo "Target:"
echo "  ${XCODE_BIN}/clang"
echo

echo "Before:"
echo "  $(${XCODE_BIN}/clang -v 2>&1 | head -n 1)"
echo

if [ ! -f "${XCODE_BIN}/clang.bak" ]; then
  echo "Nothing to do."
  exit 1
fi

echo "Unistalling..."
echo

sudo rm "${XCODE_BIN}/libPlugin.dylib"
sudo rm "${XCODE_BIN}/libPluginCore.dylib"
sudo rm "${XCODE_BIN}/clang"
sudo mv "${XCODE_BIN}/clang.bak" "${XCODE_BIN}/clang"
echo

echo "After:"
echo "  $(${XCODE_BIN}/clang -v 2>&1 | head -n 1)"
echo

echo "Done."
