#!/usr/bin/env python

import os
import sys


def get_clang_path():
    f = os.popen('clang -v 2>&1')
    for ln in f.readlines():
        if ln.startswith('InstalledDir: '):
            return os.path.join(ln.strip()[14:], 'clang')


def get_clang_arch():
    f = os.popen('clang -v 2>&1')
    for ln in f.readlines():
        if ln.startswith('Target: '):
            return ln.strip()[8:].split('-')[0]


def get_file_symbols(file, arch, ):
    f = os.popen('nm -arch {} -U {}'.format(arch, file))
    syms = dict()
    for s in f.readlines():
        sp = s.strip().split()
        if 'llvm' in sp[2]:
            syms[sp[2]] = sp[1]
    return syms


def get_undefined_file_symbols(file, arch, ):
    f = os.popen('nm -arch {} -u -j {}'.format(arch, file))
    return filter(lambda s: 'llvm' in s, [s.strip() for s in f.readlines()])


if __name__ == '__main__':
    if len(sys.argv) > 1:
        arg = sys.argv[1]
    else:
        arg = 'libPlugin.dylib'

    arch = get_clang_arch()
    clang_symbols = get_file_symbols(get_clang_path(), arch)
    target_symbols = get_undefined_file_symbols(arg, arch)
    k = 0
    for sym in target_symbols:
        if sym not in clang_symbols:
            k += 1
            print('undefined symbol {}'.format(sym))
            continue
        if clang_symbols[sym] not in 'ST':
            print('local symbol {}'.format(sym))
    print('{} undef symbols.'.format(k))
