/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcExactlyOnceOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.xa.CheckpointAndXid;
import org.apache.flink.connector.jdbc.xa.JdbcXaSinkFunctionState;
import org.apache.flink.connector.jdbc.xa.XaFacade;
import org.apache.flink.connector.jdbc.xa.XaGroupOps;
import org.apache.flink.connector.jdbc.xa.XaGroupOpsImpl;
import org.apache.flink.connector.jdbc.xa.XaSinkStateHandler;
import org.apache.flink.connector.jdbc.xa.XaSinkStateHandlerImpl;
import org.apache.flink.connector.jdbc.xa.XidGenerator;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcXaSinkFunction<T>
extends AbstractRichFunction
implements CheckpointedFunction,
CheckpointListener,
SinkFunction<T>,
AutoCloseable,
InputTypeConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcXaSinkFunction.class);
    private final XaFacade xaFacade;
    private final XaGroupOps xaGroupOps;
    private final XidGenerator xidGenerator;
    private final JdbcOutputFormat<T, ?, ?> outputFormat;
    private final XaSinkStateHandler stateHandler;
    private final JdbcExactlyOnceOptions options;
    private transient List<CheckpointAndXid> preparedXids = new ArrayList<CheckpointAndXid>();
    private transient Deque<Xid> hangingXids = new LinkedList<Xid>();
    private transient Xid currentXid;

    public JdbcXaSinkFunction(JdbcOutputFormat<T, ?, ?> outputFormat, XaFacade xaFacade) {
        this(outputFormat, xaFacade, XidGenerator.semanticXidGenerator(), new XaSinkStateHandlerImpl(), JdbcExactlyOnceOptions.builder().build(), new XaGroupOpsImpl(xaFacade));
    }

    public JdbcXaSinkFunction(String sql, JdbcStatementBuilder<T> statementBuilder, XaFacade xaFacade, JdbcExecutionOptions executionOptions, JdbcExactlyOnceOptions options) {
        this(new JdbcOutputFormat(xaFacade, executionOptions, (JdbcOutputFormat.StatementExecutorFactory & Serializable)context -> JdbcBatchStatementExecutor.simple(sql, statementBuilder, Function.identity()), JdbcOutputFormat.RecordExtractor.identity()), xaFacade, XidGenerator.semanticXidGenerator(), new XaSinkStateHandlerImpl(), options, new XaGroupOpsImpl(xaFacade));
    }

    public JdbcXaSinkFunction(JdbcOutputFormat<T, ?, ?> outputFormat, XaFacade xaFacade, XidGenerator xidGenerator, XaSinkStateHandler stateHandler, JdbcExactlyOnceOptions options, XaGroupOps xaGroupOps) {
        Preconditions.checkArgument((outputFormat.getExecutionOptions().getMaxRetries() == 0 ? 1 : 0) != 0, (Object)"JDBC XA sink requires maxRetries equal to 0, otherwise it could cause duplicates. See issue FLINK-22311 for details.");
        this.xaFacade = (XaFacade)Preconditions.checkNotNull((Object)xaFacade);
        this.xidGenerator = (XidGenerator)Preconditions.checkNotNull((Object)xidGenerator);
        this.outputFormat = (JdbcOutputFormat)Preconditions.checkNotNull(outputFormat);
        this.stateHandler = (XaSinkStateHandler)Preconditions.checkNotNull((Object)stateHandler);
        this.options = (JdbcExactlyOnceOptions)Preconditions.checkNotNull((Object)options);
        this.xaGroupOps = xaGroupOps;
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        JdbcXaSinkFunctionState state = this.stateHandler.load(context);
        this.hangingXids = new LinkedList<Xid>(state.getHanging());
        this.preparedXids = new ArrayList<CheckpointAndXid>(state.getPrepared());
        LOG.info("initialized state: prepared xids: {}, hanging xids: {}", (Object)this.preparedXids.size(), (Object)this.hangingXids.size());
    }

    public void open(Configuration configuration) throws Exception {
        super.open(configuration);
        if (this.hasNoCheckpointingEnabled()) {
            throw new IllegalArgumentException("The exactly-once requires checkpointing to be enabled.");
        }
        this.xidGenerator.open();
        this.xaFacade.open();
        this.hangingXids = new LinkedList<Xid>(this.xaGroupOps.failOrRollback(this.hangingXids).getForRetry());
        this.commitUpToCheckpoint(Optional.empty());
        if (this.options.isDiscoverAndRollbackOnRecovery()) {
            this.xaGroupOps.recoverAndRollback(this.getRuntimeContext(), this.xidGenerator);
        }
        this.beginTx(0L);
        this.outputFormat.setRuntimeContext(this.getRuntimeContext());
        this.outputFormat.open(this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks());
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        LOG.debug("snapshot state, checkpointId={}", (Object)context.getCheckpointId());
        this.prepareCurrentTx(context.getCheckpointId());
        this.beginTx(context.getCheckpointId() + 1L);
        this.stateHandler.store(JdbcXaSinkFunctionState.of(this.preparedXids, this.hangingXids));
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.commitUpToCheckpoint(Optional.of(checkpointId));
    }

    public void invoke(T value, SinkFunction.Context context) throws IOException {
        Preconditions.checkState((this.currentXid != null ? 1 : 0) != 0, (Object)"current xid must not be null");
        if (LOG.isTraceEnabled()) {
            LOG.trace("invoke, xid: {}, value: {}", (Object)this.currentXid, (Object)value);
        }
        this.outputFormat.writeRecord(value);
    }

    public void finish() throws Exception {
        this.snapshotState(new FunctionSnapshotContext(){

            public long getCheckpointId() {
                return Long.MAX_VALUE;
            }

            public long getCheckpointTimestamp() {
                return System.currentTimeMillis();
            }
        });
        this.notifyCheckpointComplete(Long.MAX_VALUE);
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.currentXid != null && this.xaFacade.isOpen()) {
            try {
                LOG.debug("remove current transaction before closing, xid={}", (Object)this.currentXid);
                this.xaFacade.failAndRollback(this.currentXid);
            }
            catch (Exception e) {
                LOG.warn("unable to fail/rollback current transaction, xid={}", (Object)this.currentXid, (Object)e);
            }
        }
        this.xaFacade.close();
        this.xidGenerator.close();
        this.currentXid = null;
        this.hangingXids = null;
        this.preparedXids = null;
    }

    private void prepareCurrentTx(long checkpointId) throws IOException {
        Preconditions.checkState((this.currentXid != null ? 1 : 0) != 0, (Object)"no current xid");
        Preconditions.checkState((!this.hangingXids.isEmpty() && this.hangingXids.peekLast().equals(this.currentXid) ? 1 : 0) != 0, (Object)"inconsistent internal state");
        this.hangingXids.pollLast();
        this.outputFormat.flush();
        try {
            this.xaFacade.endAndPrepare(this.currentXid);
            this.preparedXids.add(CheckpointAndXid.createNew(checkpointId, this.currentXid));
        }
        catch (XaFacade.EmptyXaTransactionException e) {
            LOG.info("empty XA transaction (skip), xid: {}, checkpoint {}", (Object)this.currentXid, (Object)checkpointId);
        }
        catch (Exception e) {
            ExceptionUtils.rethrowIOException((Throwable)e);
        }
        this.currentXid = null;
    }

    private void beginTx(long checkpointId) throws Exception {
        Preconditions.checkState((this.currentXid == null ? 1 : 0) != 0, (Object)"currentXid not null");
        this.currentXid = this.xidGenerator.generateXid(this.getRuntimeContext(), checkpointId);
        this.hangingXids.offerLast(this.currentXid);
        this.xaFacade.start(this.currentXid);
        if (checkpointId > 0L) {
            this.outputFormat.updateExecutor(false);
        }
    }

    private void commitUpToCheckpoint(Optional<Long> checkpointInclusive) {
        Tuple2<List<CheckpointAndXid>, List<CheckpointAndXid>> splittedXids = this.split(this.preparedXids, checkpointInclusive, true);
        if (((List)splittedXids.f0).isEmpty()) {
            checkpointInclusive.ifPresent(cp -> LOG.warn("nothing to commit up to checkpoint: {}", cp));
        } else {
            this.preparedXids = (List)splittedXids.f1;
            this.preparedXids.addAll(this.xaGroupOps.commit((List)splittedXids.f0, this.options.isAllowOutOfOrderCommits(), this.options.getMaxCommitAttempts()).getForRetry());
        }
    }

    private Tuple2<List<CheckpointAndXid>, List<CheckpointAndXid>> split(List<CheckpointAndXid> list, Optional<Long> checkpointInclusive, boolean checkpointIntoLo) {
        return checkpointInclusive.map(cp -> this.split(this.preparedXids, (long)cp, checkpointIntoLo)).orElse(new Tuple2(list, new ArrayList()));
    }

    private Tuple2<List<CheckpointAndXid>, List<CheckpointAndXid>> split(List<CheckpointAndXid> list, long checkpoint, boolean checkpointIntoLo) {
        ArrayList lo = new ArrayList(list.size() / 2);
        ArrayList hi = new ArrayList(list.size() / 2);
        list.forEach(i -> {
            if (i.checkpointId < checkpoint || i.checkpointId == checkpoint && checkpointIntoLo) {
                lo.add(i);
            } else {
                hi.add(i);
            }
        });
        return new Tuple2(lo, hi);
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        this.outputFormat.setInputType(type, executionConfig);
    }

    private boolean hasNoCheckpointingEnabled() {
        RuntimeContext runtimeContext = this.getRuntimeContext();
        return !(runtimeContext instanceof StreamingRuntimeContext) || !((StreamingRuntimeContext)runtimeContext).isCheckpointingEnabled();
    }
}

