/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferReducedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableInsertOrUpdateStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableSimpleStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class JdbcOutputFormatBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private InternalJdbcConnectionOptions jdbcOptions;
    private JdbcExecutionOptions executionOptions;
    private JdbcDmlOptions dmlOptions;
    private TypeInformation<RowData> rowDataTypeInformation;
    private DataType[] fieldDataTypes;

    public JdbcOutputFormatBuilder setJdbcOptions(InternalJdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
        return this;
    }

    public JdbcOutputFormatBuilder setJdbcExecutionOptions(JdbcExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    public JdbcOutputFormatBuilder setJdbcDmlOptions(JdbcDmlOptions dmlOptions) {
        this.dmlOptions = dmlOptions;
        return this;
    }

    public JdbcOutputFormatBuilder setRowDataTypeInfo(TypeInformation<RowData> rowDataTypeInfo) {
        this.rowDataTypeInformation = rowDataTypeInfo;
        return this;
    }

    public JdbcOutputFormatBuilder setFieldDataTypes(DataType[] fieldDataTypes) {
        this.fieldDataTypes = fieldDataTypes;
        return this;
    }

    public JdbcOutputFormat<RowData, ?, ?> build() {
        Preconditions.checkNotNull((Object)this.jdbcOptions, (String)"jdbc options can not be null");
        Preconditions.checkNotNull((Object)this.dmlOptions, (String)"jdbc dml options can not be null");
        Preconditions.checkNotNull((Object)this.executionOptions, (String)"jdbc execution options can not be null");
        LogicalType[] logicalTypes = (LogicalType[])Arrays.stream(this.fieldDataTypes).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        if (this.dmlOptions.getKeyFields().isPresent() && this.dmlOptions.getKeyFields().get().length > 0) {
            return new JdbcOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, (JdbcOutputFormat.StatementExecutorFactory & Serializable)ctx -> JdbcOutputFormatBuilder.createBufferReduceExecutor(this.dmlOptions, ctx, this.rowDataTypeInformation, logicalTypes), JdbcOutputFormat.RecordExtractor.identity());
        }
        String sql = this.dmlOptions.getDialect().getInsertIntoStatement(this.dmlOptions.getTableName(), this.dmlOptions.getFieldNames());
        return new JdbcOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, (JdbcOutputFormat.StatementExecutorFactory & Serializable)ctx -> JdbcOutputFormatBuilder.createSimpleBufferedExecutor(ctx, this.dmlOptions.getDialect(), this.dmlOptions.getFieldNames(), logicalTypes, sql, this.rowDataTypeInformation), JdbcOutputFormat.RecordExtractor.identity());
    }

    private static JdbcBatchStatementExecutor<RowData> createBufferReduceExecutor(JdbcDmlOptions opt, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo, LogicalType[] fieldTypes) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        JdbcDialect dialect = opt.getDialect();
        String tableName = opt.getTableName();
        String[] pkNames = opt.getKeyFields().get();
        int[] pkFields = Arrays.stream(pkNames).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        LogicalType[] pkTypes = (LogicalType[])Arrays.stream(pkFields).mapToObj(f -> fieldTypes[f]).toArray(LogicalType[]::new);
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        Function<RowData, RowData> valueTransform = ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity();
        return new TableBufferReducedStatementExecutor(JdbcOutputFormatBuilder.createUpsertRowExecutor(dialect, tableName, opt.getFieldNames(), fieldTypes, pkFields, pkNames, pkTypes), JdbcOutputFormatBuilder.createDeleteExecutor(dialect, tableName, pkNames, pkTypes), JdbcOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields), valueTransform);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleBufferedExecutor(RuntimeContext ctx, JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql, TypeInformation<RowData> rowDataTypeInfo) {
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        return new TableBufferedStatementExecutor(JdbcOutputFormatBuilder.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql), ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity());
    }

    private static JdbcBatchStatementExecutor<RowData> createUpsertRowExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        return dialect.getUpsertStatement(tableName, fieldNames, pkNames).map(sql -> JdbcOutputFormatBuilder.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql)).orElseGet(() -> JdbcOutputFormatBuilder.createInsertOrUpdateExecutor(dialect, tableName, fieldNames, fieldTypes, pkFields, pkNames, pkTypes));
    }

    private static JdbcBatchStatementExecutor<RowData> createDeleteExecutor(JdbcDialect dialect, String tableName, String[] pkNames, LogicalType[] pkTypes) {
        String deleteSql = dialect.getDeleteStatement(tableName, pkNames);
        return JdbcOutputFormatBuilder.createSimpleRowExecutor(dialect, pkNames, pkTypes, deleteSql);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleRowExecutor(JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql) {
        JdbcRowConverter rowConverter = dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes));
        return new TableSimpleStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, sql, fieldNames), rowConverter);
    }

    private static JdbcBatchStatementExecutor<RowData> createInsertOrUpdateExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        String existStmt = dialect.getRowExistsStatement(tableName, pkNames);
        String insertStmt = dialect.getInsertIntoStatement(tableName, fieldNames);
        String updateStmt = dialect.getUpdateStatement(tableName, fieldNames, pkNames);
        return new TableInsertOrUpdateStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, existStmt, pkNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, insertStmt, fieldNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, updateStmt, fieldNames), dialect.getRowConverter(RowType.of((LogicalType[])pkTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), JdbcOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields));
    }

    private static Function<RowData, RowData> createRowKeyExtractor(LogicalType[] logicalTypes, int[] pkFields) {
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)logicalTypes[pkFields[i]], (int)pkFields[i]);
        }
        return row -> JdbcOutputFormatBuilder.getPrimaryKey(row, fieldGetters);
    }

    private static RowData getPrimaryKey(RowData row, RowData.FieldGetter[] fieldGetters) {
        GenericRowData pkRow = new GenericRowData(fieldGetters.length);
        for (int i = 0; i < fieldGetters.length; ++i) {
            pkRow.setField(i, fieldGetters[i].getFieldOrNull(row));
        }
        return pkRow;
    }
}

