/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.options;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.options.JdbcTypedQueryOptions;
import org.apache.flink.util.Preconditions;

public class JdbcDmlOptions
extends JdbcTypedQueryOptions {
    private static final long serialVersionUID = 1L;
    private final String[] fieldNames;
    @Nullable
    private final String[] keyFields;
    private final String tableName;
    private final JdbcDialect dialect;

    public static JdbcDmlOptionsBuilder builder() {
        return new JdbcDmlOptionsBuilder();
    }

    private JdbcDmlOptions(String tableName, JdbcDialect dialect, String[] fieldNames, int[] fieldTypes, String[] keyFields) {
        super(fieldTypes);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (String)"table is empty");
        this.dialect = (JdbcDialect)Preconditions.checkNotNull((Object)dialect, (String)"dialect is empty");
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"field names is empty");
        this.keyFields = keyFields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Optional<String[]> getKeyFields() {
        return Optional.ofNullable(this.keyFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcDmlOptions that = (JdbcDmlOptions)o;
        return Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.keyFields, that.keyFields) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.dialect.dialectName(), that.dialect.dialectName());
    }

    public int hashCode() {
        int result = Objects.hash(this.tableName, this.dialect.dialectName());
        result = 31 * result + Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode(this.keyFields);
        return result;
    }

    public static class JdbcDmlOptionsBuilder
    extends JdbcTypedQueryOptions.JdbcUpdateQueryOptionsBuilder<JdbcDmlOptionsBuilder> {
        private String tableName;
        private String[] fieldNames;
        private String[] keyFields;
        private JdbcDialect dialect;

        @Override
        protected JdbcDmlOptionsBuilder self() {
            return this;
        }

        public JdbcDmlOptionsBuilder withFieldNames(String field, String ... fieldNames) {
            this.fieldNames = JdbcDmlOptionsBuilder.concat(field, fieldNames);
            return this;
        }

        public JdbcDmlOptionsBuilder withFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public JdbcDmlOptionsBuilder withKeyFields(String keyField, String ... keyFields) {
            this.keyFields = JdbcDmlOptionsBuilder.concat(keyField, keyFields);
            return this;
        }

        public JdbcDmlOptionsBuilder withKeyFields(String[] keyFields) {
            this.keyFields = keyFields;
            return this;
        }

        public JdbcDmlOptionsBuilder withTableName(String tableName) {
            this.tableName = tableName;
            return this.self();
        }

        public JdbcDmlOptionsBuilder withDialect(JdbcDialect dialect) {
            this.dialect = dialect;
            return this.self();
        }

        public JdbcDmlOptions build() {
            return new JdbcDmlOptions(this.tableName, this.dialect, this.fieldNames, this.fieldTypes, this.keyFields);
        }

        static String[] concat(String first, String ... next) {
            if (next == null || next.length == 0) {
                return new String[]{first};
            }
            return (String[])Stream.concat(Stream.of(new String[]{first}), Stream.of(next)).toArray(String[]::new);
        }
    }
}

