/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.groups.OperatorMetricGroup;

public class JdbcMetricRecorder {
    private final OperatorMetricGroup operatorMetricGroup;
    private Counter numRecordsOut;
    private final LatencyGauge currentSendTime = new LatencyGauge();

    public JdbcMetricRecorder(OperatorMetricGroup operatorMetricGroup) {
        this.operatorMetricGroup = operatorMetricGroup;
    }

    public void registerSinkMetrics() {
        this.numRecordsOut = this.operatorMetricGroup.getIOMetricGroup().getNumRecordsOutCounter();
        this.operatorMetricGroup.gauge("currentSendTime", (Gauge)this.currentSendTime);
    }

    public Counter getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public LatencyGauge getCurrentSendTime() {
        return this.currentSendTime;
    }

    public static class LatencyGauge
    implements Gauge<Double> {
        private Double value;

        public void report(long timeDelta, long batchSize) {
            if (batchSize != 0L) {
                this.value = 1.0 * (double)timeDelta / (double)batchSize;
            }
        }

        public Double getValue() {
            return this.value;
        }
    }
}

