/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.TableJdbcUpsertOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.metrics.JdbcMetricRecorder;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.function.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcOutputFormat<In, JdbcIn, JdbcExec extends JdbcBatchStatementExecutor<JdbcIn>>
extends RichOutputFormat<In>
implements Flushable,
InputTypeConfigurable {
    protected final JdbcConnectionProvider connectionProvider;
    @Nullable
    private TypeSerializer<In> serializer;
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcOutputFormat.class);
    private final JdbcExecutionOptions executionOptions;
    private final StatementExecutorFactory<JdbcExec> statementExecutorFactory;
    private final RecordExtractor<In, JdbcIn> jdbcRecordExtractor;
    private transient JdbcExec jdbcStatementExecutor;
    private transient int batchCount = 0;
    private volatile transient boolean closed = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient Exception flushException;
    protected JdbcMetricRecorder sinkMetricRecorder;

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        if (executionConfig.isObjectReuseEnabled()) {
            this.serializer = type.createSerializer(executionConfig);
        }
    }

    public JdbcOutputFormat(@Nonnull JdbcConnectionProvider connectionProvider, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull StatementExecutorFactory<JdbcExec> statementExecutorFactory, @Nonnull RecordExtractor<In, JdbcIn> recordExtractor) {
        this.connectionProvider = (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider);
        this.executionOptions = (JdbcExecutionOptions)Preconditions.checkNotNull((Object)executionOptions);
        this.statementExecutorFactory = (StatementExecutorFactory)Preconditions.checkNotNull(statementExecutorFactory);
        this.jdbcRecordExtractor = (RecordExtractor)Preconditions.checkNotNull(recordExtractor);
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.sinkMetricRecorder = new JdbcMetricRecorder(this.getRuntimeContext().getMetricGroup());
        this.sinkMetricRecorder.registerSinkMetrics();
        try {
            this.connectionProvider.getOrEstablishConnection();
        }
        catch (Exception e) {
            throw new IOException("unable to open JDBC writer", e);
        }
        this.jdbcStatementExecutor = this.createAndOpenStatementExecutor(this.statementExecutorFactory);
        if (this.executionOptions.getBatchIntervalMs() != 0L && this.executionOptions.getBatchSize() != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                JdbcOutputFormat jdbcOutputFormat = this;
                synchronized (jdbcOutputFormat) {
                    if (!this.closed) {
                        try {
                            this.flush();
                        }
                        catch (Exception e) {
                            this.flushException = e;
                        }
                    }
                }
            }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    private JdbcExec createAndOpenStatementExecutor(StatementExecutorFactory<JdbcExec> statementExecutorFactory) throws IOException {
        JdbcBatchStatementExecutor exec = (JdbcBatchStatementExecutor)statementExecutorFactory.apply(this.getRuntimeContext());
        try {
            exec.prepareStatements(this.connectionProvider.getConnection());
        }
        catch (SQLException e) {
            throw new IOException("unable to open JDBC writer", e);
        }
        return (JdbcExec)exec;
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to JDBC failed.", this.flushException);
        }
    }

    public final synchronized void writeRecord(In record) throws IOException {
        this.checkFlushException();
        try {
            In recordCopy = this.copyIfNecessary(record);
            this.addToBatch(record, this.jdbcRecordExtractor.apply(recordCopy));
            this.sinkMetricRecorder.getNumRecordsOut().inc();
            ++this.batchCount;
            if (this.executionOptions.getBatchSize() > 0 && this.batchCount >= this.executionOptions.getBatchSize()) {
                this.flush();
            }
        }
        catch (Exception e) {
            throw new IOException("Writing records to JDBC failed.", e);
        }
    }

    private In copyIfNecessary(In record) {
        return (In)(this.serializer == null ? record : this.serializer.copy(record));
    }

    protected void addToBatch(In original, JdbcIn extracted) throws SQLException {
        this.jdbcStatementExecutor.addToBatch(extracted);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkFlushException();
        for (int i = 0; i <= this.executionOptions.getMaxRetries(); ++i) {
            try {
                long beforeSend = System.currentTimeMillis();
                this.attemptFlush();
                this.sinkMetricRecorder.getCurrentSendTime().report(System.currentTimeMillis() - beforeSend, this.batchCount);
                this.batchCount = 0;
                break;
            }
            catch (SQLException e) {
                LOG.error("JDBC executeBatch error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.executionOptions.getMaxRetries()) {
                    throw new IOException(e);
                }
                try {
                    if (!this.connectionProvider.isConnectionValid()) {
                        this.updateExecutor(true);
                    }
                }
                catch (Exception exception) {
                    LOG.error("JDBC connection is not valid, and reestablish connection failed.", exception);
                    throw new IOException("Reestablish JDBC connection failed", exception);
                }
                try {
                    Thread.sleep(1000 * i);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
        }
    }

    protected void attemptFlush() throws SQLException {
        this.jdbcStatementExecutor.executeBatch();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            if (this.batchCount > 0) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    LOG.warn("Writing records to JDBC failed.", e);
                    throw new RuntimeException("Writing records to JDBC failed.", e);
                }
            }
            try {
                if (this.jdbcStatementExecutor != null) {
                    this.jdbcStatementExecutor.closeStatements();
                }
            }
            catch (SQLException e) {
                LOG.warn("Close JDBC writer failed.", e);
            }
        }
        this.connectionProvider.closeConnection();
        this.checkFlushException();
    }

    public static Builder builder() {
        return new Builder();
    }

    static JdbcBatchStatementExecutor<Row> createSimpleRowExecutor(String sql, int[] fieldTypes, boolean objectReuse) {
        return JdbcBatchStatementExecutor.simple(sql, JdbcOutputFormat.createRowJdbcStatementBuilder(fieldTypes), objectReuse ? Row::copy : Function.identity());
    }

    static JdbcStatementBuilder<Row> createRowJdbcStatementBuilder(int[] types) {
        return (st, record) -> JdbcUtils.setRecordToStatement(st, types, record);
    }

    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
        this.jdbcStatementExecutor.closeStatements();
        this.jdbcStatementExecutor.prepareStatements(reconnect ? this.connectionProvider.reestablishConnection() : this.connectionProvider.getConnection());
    }

    public JdbcExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    @VisibleForTesting
    public Connection getConnection() {
        return this.connectionProvider.getConnection();
    }

    public static class Builder {
        private InternalJdbcConnectionOptions options;
        private String[] fieldNames;
        private String[] keyFields;
        private int[] fieldTypes;
        private JdbcExecutionOptions.Builder executionOptionsBuilder = JdbcExecutionOptions.builder();

        public Builder setOptions(InternalJdbcConnectionOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder setKeyFields(String[] keyFields) {
            this.keyFields = keyFields;
            return this;
        }

        public Builder setFieldTypes(int[] fieldTypes) {
            this.fieldTypes = fieldTypes;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.executionOptionsBuilder.withBatchSize(flushMaxSize);
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.executionOptionsBuilder.withBatchIntervalMs(flushIntervalMills);
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.executionOptionsBuilder.withMaxRetries(maxRetryTimes);
            return this;
        }

        public JdbcOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>> build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.fieldNames, (String)"No fieldNames supplied.");
            JdbcDmlOptions dml = ((JdbcDmlOptions.JdbcDmlOptionsBuilder)JdbcDmlOptions.builder().withTableName(this.options.getTableName()).withDialect(this.options.getDialect()).withFieldNames(this.fieldNames).withKeyFields(this.keyFields).withFieldTypes(this.fieldTypes)).build();
            if (dml.getKeyFields().isPresent() && dml.getKeyFields().get().length > 0) {
                return new TableJdbcUpsertOutputFormat(new SimpleJdbcConnectionProvider(this.options), dml, this.executionOptionsBuilder.build());
            }
            String sql = FieldNamedPreparedStatementImpl.parseNamedStatement(this.options.getDialect().getInsertIntoStatement(dml.getTableName(), dml.getFieldNames()), new HashMap<String, List<Integer>>());
            return new JdbcOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>>(new SimpleJdbcConnectionProvider(this.options), this.executionOptionsBuilder.build(), (StatementExecutorFactory & Serializable)ctx -> JdbcOutputFormat.createSimpleRowExecutor(sql, dml.getFieldTypes(), ctx.getExecutionConfig().isObjectReuseEnabled()), tuple2 -> {
                Preconditions.checkArgument((boolean)((Boolean)tuple2.f0));
                return (Row)tuple2.f1;
            });
        }
    }

    public static interface StatementExecutorFactory<T extends JdbcBatchStatementExecutor<?>>
    extends SerializableFunction<RuntimeContext, T> {
    }

    public static interface RecordExtractor<F, T>
    extends Function<F, T>,
    Serializable {
        public static <T> RecordExtractor<T, T> identity() {
            return x -> x;
        }
    }
}

