/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.NullNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.util.Iterator;
import java.util.Map;

public class SchemaBuilderUtil {
    public static Schema toConnectSchema(String key, JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case NUMBER: {
                if (node.isInt()) {
                    return Schema.OPTIONAL_INT32_SCHEMA;
                }
                if (node.isLong()) {
                    return Schema.OPTIONAL_INT64_SCHEMA;
                }
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)node;
                return arrayNode.isEmpty() ? null : SchemaBuilder.array(SchemaBuilderUtil.toConnectSchemaWithCycles(key, arrayNode)).optional().build();
            }
            case OBJECT: {
                SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(key).optional();
                if (node != null) {
                    Iterator<Map.Entry<String, JsonNode>> fieldsEntries = node.fields();
                    while (fieldsEntries.hasNext()) {
                        Map.Entry<String, JsonNode> fieldEntry = fieldsEntries.next();
                        String fieldName = fieldEntry.getKey();
                        Schema fieldSchema = SchemaBuilderUtil.toConnectSchema(key + "." + fieldName, fieldEntry.getValue());
                        if (fieldSchema == null || SchemaBuilderUtil.hasField(schemaBuilder, fieldName)) continue;
                        schemaBuilder.field(fieldName, fieldSchema);
                    }
                }
                return schemaBuilder.build();
            }
        }
        return null;
    }

    private static Schema toConnectSchemaWithCycles(String key, ArrayNode array) throws ConnectException {
        Schema schema = null;
        JsonNode sample = SchemaBuilderUtil.getFirstArrayElement(array);
        if (sample.isObject()) {
            Iterator<JsonNode> elements = array.elements();
            while (elements.hasNext()) {
                JsonNode element = elements.next();
                if (!element.isObject()) continue;
                if (schema == null) {
                    schema = SchemaBuilderUtil.toConnectSchema(key, element);
                    continue;
                }
                schema = SchemaBuilderUtil.toConnectSchema(key, element);
            }
        } else {
            schema = SchemaBuilderUtil.toConnectSchema(null, sample);
            if (schema == null) {
                throw new ConnectException(String.format("Array '%s' has unrecognized member schema.", array.asText()));
            }
        }
        return schema;
    }

    private static JsonNode getFirstArrayElement(ArrayNode array) throws ConnectException {
        JsonNode refNode = NullNode.getInstance();
        Schema refSchema = null;
        Iterator<JsonNode> elements = array.elements();
        while (elements.hasNext()) {
            Schema elementSchema;
            JsonNode element = elements.next();
            if (element.isNull()) continue;
            if (refNode.isNull()) {
                refNode = element;
            }
            if (element.getNodeType() != refNode.getNodeType()) {
                throw new ConnectException(String.format("Field is not a homogenous array (%s x %s).", refNode.asText(), element.getNodeType().toString()));
            }
            if (refNode.getNodeType() != JsonNodeType.NUMBER) continue;
            if (refSchema == null) {
                refSchema = SchemaBuilderUtil.toConnectSchema(null, refNode);
            }
            if (refSchema == (elementSchema = SchemaBuilderUtil.toConnectSchema(null, element))) continue;
            throw new ConnectException(String.format("Field is not a homogenous array (%s x %s), different number types (%s x %s)", refNode.asText(), element.asText(), refSchema, elementSchema));
        }
        return refNode;
    }

    private static boolean hasField(SchemaBuilder builder, String fieldName) {
        return builder.field(fieldName) != null;
    }
}

