/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.signal.ExecuteSnapshotKafkaSignal;
import io.debezium.connector.mysql.signal.KafkaSignalThread;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlReadOnlyIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
extends AbstractIncrementalSnapshotChangeEventSource<MySqlPartition, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlReadOnlyIncrementalSnapshotChangeEventSource.class);
    private final String showMasterStmt = "SHOW MASTER STATUS";
    private final KafkaSignalThread<T> kafkaSignal;

    public MySqlReadOnlyIncrementalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<MySqlPartition, T> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener<MySqlPartition> progressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
        this.kafkaSignal = new KafkaSignalThread(MySqlConnector.class, config, this);
    }

    @Override
    public void init(MySqlPartition partition, OffsetContext offsetContext) {
        super.init(partition, offsetContext);
        Long signalOffset = this.getContext().getSignalOffset();
        if (signalOffset != null) {
            this.kafkaSignal.seek(signalOffset);
        }
        this.kafkaSignal.start();
    }

    @Override
    public void processMessage(MySqlPartition partition, DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        this.checkEnqueuedSnapshotSignals(partition, offsetContext);
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", dataCollectionId, key, this.window);
        boolean windowClosed = this.getContext().updateWindowState(offsetContext);
        if (windowClosed) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk(partition);
        } else if (!this.window.isEmpty() && this.getContext().deduplicationNeeded()) {
            this.deduplicateWindow(dataCollectionId, key);
        }
    }

    @Override
    public void processHeartbeat(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        this.checkEnqueuedSnapshotSignals(partition, offsetContext);
        this.readUntilGtidChange(partition, offsetContext);
    }

    private void readUntilGtidChange(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        String currentGtid = this.getContext().getCurrentGtid(offsetContext);
        while (this.getContext().snapshotRunning() && this.getContext().reachedHighWatermark(currentGtid)) {
            this.getContext().closeWindow();
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk(partition);
            if (currentGtid != null || !this.getContext().watermarksChanged()) continue;
            return;
        }
    }

    @Override
    public void processFilteredEvent(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        this.checkEnqueuedSnapshotSignals(partition, offsetContext);
        boolean windowClosed = this.getContext().updateWindowState(offsetContext);
        if (windowClosed) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk(partition);
        }
    }

    public void enqueueDataCollectionNamesToSnapshot(List<String> dataCollectionIds, long signalOffset) {
        this.getContext().enqueueDataCollectionsToSnapshot(dataCollectionIds, signalOffset);
    }

    @Override
    public void processTransactionStartedEvent(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        boolean windowClosed = this.getContext().updateWindowState(offsetContext);
        if (windowClosed) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk(partition);
        }
    }

    @Override
    public void processTransactionCommittedEvent(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        this.readUntilGtidChange(partition, offsetContext);
    }

    protected void updateLowWatermark() {
        this.getExecutedGtidSet(this.getContext()::setLowWatermark);
    }

    protected void updateHighWatermark() {
        this.getExecutedGtidSet(this.getContext()::setHighWatermark);
    }

    private void getExecutedGtidSet(Consumer<GtidSet> watermark) {
        try {
            this.jdbcConnection.query("SHOW MASTER STATUS", rs -> {
                if (rs.next()) {
                    if (rs.getMetaData().getColumnCount() > 4) {
                        String gtidSet = rs.getString(5);
                        watermark.accept(new GtidSet(gtidSet));
                    } else {
                        throw new UnsupportedOperationException("Need to add support for executed GTIDs for versions prior to 5.6.5");
                    }
                }
            });
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new DebeziumException(e);
        }
    }

    @Override
    protected void emitWindowOpen() {
        this.updateLowWatermark();
    }

    @Override
    protected void emitWindowClose(MySqlPartition partition) throws InterruptedException {
        this.updateHighWatermark();
        if (this.getContext().serverUuidChanged()) {
            this.rereadChunk(partition);
        }
    }

    @Override
    protected void sendEvent(MySqlPartition partition, EventDispatcher<MySqlPartition, T> dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        SourceInfo sourceInfo = ((MySqlOffsetContext)offsetContext).getSource();
        String query = sourceInfo.getQuery();
        sourceInfo.setQuery(null);
        super.sendEvent(partition, dispatcher, offsetContext, row);
        sourceInfo.setQuery(query);
    }

    private void checkEnqueuedSnapshotSignals(MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        while (this.getContext().hasExecuteSnapshotSignals()) {
            this.addDataCollectionNamesToSnapshot(this.getContext().getExecuteSnapshotSignals(), partition, offsetContext);
        }
    }

    private void addDataCollectionNamesToSnapshot(ExecuteSnapshotKafkaSignal executeSnapshotSignal, MySqlPartition partition, OffsetContext offsetContext) throws InterruptedException {
        super.addDataCollectionNamesToSnapshot(partition, executeSnapshotSignal.getDataCollections(), offsetContext);
        this.getContext().setSignalOffset(executeSnapshotSignal.getSignalOffset());
    }

    private MySqlReadOnlyIncrementalSnapshotContext<T> getContext() {
        return (MySqlReadOnlyIncrementalSnapshotContext)this.context;
    }
}

