/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table.dim;

import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import com.alibaba.ververica.connectors.common.util.ConnectionPool;
import com.alibaba.ververica.connectors.jdbc.dim.JdbcRowFetcherBase;
import com.alibaba.ververica.connectors.jdbc.util.JdbcRowConverter;
import com.alibaba.ververica.connectors.jdbc.util.MySqlUtils;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariDataSource;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.MySqlOptions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlRowFetcher
extends JdbcRowFetcherBase {
    private static final long serialVersionUID = 281376837810034203L;
    private static final Logger LOG = LoggerFactory.getLogger(MySqlRowFetcher.class);
    private static final ConnectionPool<HikariDataSource> DATA_SOURCE_POOL = new ConnectionPool();
    private transient HikariDataSource dataSource = null;
    private final DataSourceOptions dataSourceOptions;
    private final InternalJdbcConnectionOptions jdbcOptions;
    private final String poolId;

    public MySqlRowFetcher(String sqlTableName, ResolvedSchema tableSchema, String[] lookupKeys, CacheStrategy cacheStrategy, int maxRetries, int maxFetchResults, DataSourceOptions dataSourceOptions, InternalJdbcConnectionOptions jdbcOptions) {
        super(sqlTableName, TableSchema.fromResolvedSchema((ResolvedSchema)tableSchema), lookupKeys, cacheStrategy, maxRetries, maxFetchResults, MySqlUtils.getSelectSql(tableSchema.getColumnNames().toArray(new String[0]), lookupKeys, sqlTableName), new Function<DataType[], JdbcRowConverter>(){

            @Override
            public JdbcRowConverter apply(DataType[] dataTypes) {
                return new JdbcRowConverter(dataTypes);
            }
        });
        this.dataSourceOptions = dataSourceOptions;
        this.jdbcOptions = jdbcOptions;
        this.poolId = jdbcOptions.getDbURL() + jdbcOptions.getUsername().orElse("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection connectToTable() {
        try {
            Class<MySqlRowFetcher> clazz = MySqlRowFetcher.class;
            synchronized (MySqlRowFetcher.class) {
                if (this.isClosed) {
                    throw new RuntimeException("MySqlRowFetcher has been closed!");
                }
                if (DATA_SOURCE_POOL.contains(this.poolId)) {
                    this.dataSource = DATA_SOURCE_POOL.get(this.poolId);
                } else {
                    this.dataSource = MySqlOptions.buildDataSourceFromOptions(this.dataSourceOptions, this.jdbcOptions);
                    DATA_SOURCE_POOL.put(this.poolId, this.dataSource);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.dataSource.getConnection();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while creating connection to MySQL.", e);
            throw new RuntimeException(String.format("Can not get connection or connect to table %s successfully.", this.poolId), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeDataSource() {
        Class<MySqlRowFetcher> clazz = MySqlRowFetcher.class;
        synchronized (MySqlRowFetcher.class) {
            LOG.info("Close data source.");
            this.isClosed = true;
            boolean removed = false;
            if (this.poolId != null && DATA_SOURCE_POOL != null) {
                removed = DATA_SOURCE_POOL.remove(this.poolId);
            }
            if (this.dataSource != null && !this.dataSource.isClosed() && removed) {
                this.dataSource.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected String getConnectorType() {
        return "MySQL";
    }

    @Override
    protected void createConnectionAndStatement() throws SQLException {
        com.ververica.connectors.mysql.utils.MySqlUtils.closeMysqlStatement(this.statement);
        com.ververica.connectors.mysql.utils.MySqlUtils.closeMysqlConnection(this.connection);
        this.connection = this.connectToTable();
        LOG.debug("queryTemplate: {}", (Object)this.queryTemplate);
        this.statement = this.connection.prepareStatement(this.queryTemplate);
    }
}

