/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table;

import com.alibaba.ververica.connectors.common.dim.DimOptions;
import com.alibaba.ververica.connectors.common.dim.cache.CacheConfig;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariConfig;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariDataSource;
import com.ververica.connectors.mysql.table.CacheStrategy;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.Preconditions;

public class MySqlOptions {
    public static final String CONNECTOR_TYPE = "MySQL";
    public static final Pattern URL_PATTERN = Pattern.compile("jdbc:mysql://(?<hostname>.+):(?<port>\\d+)/(?<dbName>\\w+)\\??.*");
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The jdbc database url.");
    public static final ConfigOption<CacheStrategy> LOOKUP_CACHE_STRATEGY = ConfigOptions.key((String)"lookup.cache.strategy").enumType(CacheStrategy.class).defaultValue((Object)CacheStrategy.NONE).withFallbackKeys(new String[]{DimOptions.CACHE_TYPE.key()}).withDescription("cache type.");
    public static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)((Long)DimOptions.MAX_CACHE_SIZE.defaultValue())).withFallbackKeys(new String[]{DimOptions.MAX_CACHE_SIZE.key()}).withDescription("when use 'LRU' cache, the max number of rows of lookup cache, over this value, the oldest rows will be eliminated.");
    public static final ConfigOption<Duration> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"lookup.cache.ttl").durationType().defaultValue((Object)Duration.ofMillis(10000L)).withDescription("the cache time to live.");
    public static final ConfigOption<Integer> LOOKUP_MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("the max retry times if write or lookup database failed");
    public static final ConfigOption<Integer> LOOKUP_JOIN_MAX_ROWS = ConfigOptions.key((String)"lookup.max-join-rows").intType().defaultValue((Object)1024).withFallbackKeys(new String[]{"maxJoinRows"});
    public static final ConfigOption<Boolean> LOOKUP_CACHE_EMPTY = ConfigOptions.key((String)"lookup.cache.cache-empty").booleanType().defaultValue((Object)true).withFallbackKeys(new String[]{DimOptions.CACHE_EMPTY.key()});
    public static final ConfigOption<String> LOOKUP_CACHE_RELOAD_TIME_BLACKLIST = ConfigOptions.key((String)"lookup.cache.reload-time-black-list").stringType().noDefaultValue().withFallbackKeys(new String[]{DimOptions.CACHE_RELOAD_TIME_BLACKLIST.key()});
    public static final ConfigOption<Integer> LOOKUP_CACHE_SCAN_LIMIT = ConfigOptions.key((String)"lookup.cache.scan-limit").intType().defaultValue((Object)100).withFallbackKeys(new String[]{DimOptions.CACHE_SCAN_LIMIT.key()});
    public static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)10000).withFallbackKeys(new String[]{"bufferSize"}).withDescription("the flush max size (includes all append, upsert and delete records), over this number of records, will flush data. The default value is 100.");
    public static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofMillis(1000L)).withDescription("the flush interval mills, over this time, asynchronous threads will flush data. The default value is 1000.");
    public static final ConfigOption<Integer> SINK_MAX_RETRIES = ConfigOptions.key((String)"sink.max-retries").intType().defaultValue((Object)3).withFallbackKeys(new String[]{"maxRetryTimes"}).withDescription("The max retry times if writing records to database failed.");
    public static final ConfigOption<Integer> SINK_BATCH_SIZE = ConfigOptions.key((String)"sink.buffer-flush.batch-size").intType().defaultValue((Object)4096).withFallbackKeys(new String[]{"batchSize"});
    public static final ConfigOption<String> SINK_EXCLUDE_UPDATE_FIELDS = ConfigOptions.key((String)"sink.exclude-update-columns").stringType().defaultValue((Object)"").withFallbackKeys(new String[]{"excludeUpdateColumns"});
    public static final ConfigOption<Boolean> SINK_IGNORE_DELETE = ConfigOptions.key((String)"sink.ignore-delete").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{"ignoreDelete"});
    public static final ConfigOption<Boolean> SINK_CREATE_TABLE_IF_NOT_EXISTS = ConfigOptions.key((String)"sink.create-table-if-not-exists").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{"createTableIfNotExists"});
    public static final ConfigOption<Integer> SINK_VARCHAR_MAX_LENGTH = ConfigOptions.key((String)"sink.varchar-length").intType().defaultValue((Object)512).withFallbackKeys(new String[]{"varcharMaxLength"});
    public static final ConfigOption<Long> SINK_MAX_SINK_TPS = ConfigOptions.key((String)"sink.limit-tps").longType().defaultValue((Object)-1L).withFallbackKeys(new String[]{"maxSinkTps"});
    public static final ConfigOption<DirtyDataStrategy> SINK_ACTION_ON_INSERT_ERROR = ConfigOptions.key((String)"sink.error-handler").enumType(DirtyDataStrategy.class).defaultValue((Object)DirtyDataStrategy.EXCEPTION).withFallbackKeys(new String[]{"actionOnInsert"});
    public static final ConfigOption<Integer> CONNECTION_MIN_IDLE = ConfigOptions.key((String)"connection.min-idle").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"connectionMinIdle"});
    public static final ConfigOption<Duration> CATALOG_CACHE_TTL = ConfigOptions.key((String)"catalog.cache.ttl").durationType().defaultValue((Object)Duration.ofMinutes(3L)).withDescription("The ttl for the catalog cache. The default value is 3 min.");
    public static final ConfigOption<Integer> CATALOG_THREAD_POOL_SIZE = ConfigOptions.key((String)"catalog.thread.pool.size").intType().defaultValue((Object)8).withDescription("The size of the thread pool for the mysql catalog.");
    public static final ConfigOption<List<String>> CATALOG_TABLE_METADATA_COLUMN = ConfigOptions.key((String)"catalog.table.metadata-columns").stringType().asList().defaultValues((Object[])new String[0]).withDescription("A semicolon-separated list of supported metadata columns to be appended to the mysql table, for example, 'catalog.table.metadata-columns'='op_ts;table_name;database_name'. By default, this list is empty.");
    public static final ConfigOption<Boolean> CATALOG_TABLE_TREAT_TINYINT1_AS_BOOL = ConfigOptions.key((String)"catalog.table.treat-tinyint1-as-boolean").booleanType().defaultValue((Object)true).withDescription("Whether treat tinyint(1) type as boolean type. MySQL catalog get tables by parsing the create table sql from 'show create table', in which MySQL will return a boolean type as tinyint(1). MySQL catalog cannot decide whether a tinyint(1) type is a boolean type. If this option is false, MySQL catalog will treat all tinyint(1) types as tinyint(1). If this option is true, MySQL catalog will treat all tinyint(1) types as boolean. MySQL Catalog will treat tinyint(1) type as boolean by default.  For MySQL source in CTAS/CDAS statement, the new added column tinyint(1) and boolean type during job running state can recognize as tinyint(1) and boolean type.");

    public static void validateConfigOptions(ReadableConfig config) {
        if (config.getOptional(LOOKUP_CACHE_STRATEGY).isPresent()) {
            CacheStrategy cacheStrategy = (CacheStrategy)((Object)config.get(LOOKUP_CACHE_STRATEGY));
            if (!(CacheStrategy.ALL.equals((Object)cacheStrategy) || CacheStrategy.LRU.equals((Object)cacheStrategy) || CacheStrategy.NONE.equals((Object)cacheStrategy))) {
                throw new IllegalArgumentException(String.format("Jdbc don't support cache strategy: %s", new Object[]{cacheStrategy}));
            }
            if (CacheStrategy.LRU.equals((Object)cacheStrategy)) {
                Preconditions.checkState(((Long)config.get(LOOKUP_CACHE_MAX_ROWS) > 0L ? 1 : 0) != 0, (Object)String.format("When using 'LRU' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_MAX_ROWS.key(), config.get(LOOKUP_CACHE_MAX_ROWS)));
                Preconditions.checkState((((Duration)config.get(LOOKUP_CACHE_TTL)).toMillis() > 0L ? 1 : 0) != 0, (Object)String.format("When using 'LRU' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_TTL.key(), config.get(LOOKUP_CACHE_TTL)));
            } else if (CacheStrategy.ALL.equals((Object)cacheStrategy)) {
                Preconditions.checkState((((Duration)config.get(LOOKUP_CACHE_TTL)).toMillis() > 0L ? 1 : 0) != 0, (Object)String.format("When using 'ALL' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_TTL.key(), config.get(LOOKUP_CACHE_TTL)));
            }
        }
        Preconditions.checkState(((Integer)config.get(LOOKUP_MAX_RETRIES) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", LOOKUP_MAX_RETRIES.key(), config.get(LOOKUP_MAX_RETRIES)));
        Preconditions.checkState(((Integer)config.get(SINK_BUFFER_FLUSH_MAX_ROWS) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_BUFFER_FLUSH_MAX_ROWS.key(), config.get(SINK_BUFFER_FLUSH_MAX_ROWS)));
        Preconditions.checkState((((Duration)config.get(SINK_BUFFER_FLUSH_INTERVAL)).toMillis() >= 0L ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_BUFFER_FLUSH_INTERVAL.key(), config.get(SINK_BUFFER_FLUSH_INTERVAL)));
        Preconditions.checkState(((Integer)config.get(SINK_MAX_RETRIES) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_MAX_RETRIES.key(), config.get(SINK_MAX_RETRIES)));
    }

    public static HikariDataSource buildDataSourceFromOptions(DataSourceOptions dataSourceOptions, InternalJdbcConnectionOptions jdbcConnectorOptions) {
        String url = (String)Preconditions.checkNotNull((Object)jdbcConnectorOptions.getDbURL(), (String)"url must not be null");
        String userName = (String)Preconditions.checkNotNull((Object)jdbcConnectorOptions.getUsername().orElse(null), (String)"username must not be null");
        String password = (String)Preconditions.checkNotNull((Object)jdbcConnectorOptions.getPassword().orElse(null), (String)"password must not be null");
        if (!url.startsWith("jdbc:mysql://")) {
            throw new IllegalArgumentException(String.format("url of %s must starts with jdbc:mysql:// format, but actual url is %s", CONNECTOR_TYPE, url));
        }
        return MySqlOptions.buildDataSourceFromOptions(url, userName, password, dataSourceOptions.getConnectionMaxSize(), dataSourceOptions.getConnectionTimeout(), dataSourceOptions.getConnectionMinIdle());
    }

    public static HikariDataSource buildDataSourceFromOptions(String url, String username, String password, int connectionMaxSize, long connectionTimeout, int connectionMinIdle) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setUsername(username);
        config.setPassword(password);
        config.setMinimumIdle(connectionMinIdle);
        config.setMaximumPoolSize(connectionMaxSize);
        config.setConnectionTimeout(connectionTimeout);
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setDataSourceProperties(new Properties());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    public static CacheConfig createCacheConfig(ReadableConfig config) {
        return MySqlOptions.createCacheConfig(config, (CacheStrategy)((Object)LOOKUP_CACHE_STRATEGY.defaultValue()));
    }

    public static CacheConfig createCacheConfig(ReadableConfig config, CacheStrategy defaultType) {
        CacheStrategy cacheType = defaultType;
        if (config.getOptional(LOOKUP_CACHE_STRATEGY).isPresent()) {
            cacheType = (CacheStrategy)((Object)config.get(LOOKUP_CACHE_STRATEGY));
        }
        if (cacheType == CacheStrategy.LRU) {
            return new CacheConfig(com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy.lru((Long)config.get(LOOKUP_CACHE_MAX_ROWS), ((Duration)config.get(LOOKUP_CACHE_TTL)).toMillis(), false, (Boolean)config.get(LOOKUP_CACHE_EMPTY)), DimOptions.parseTimeRangeBlacklist((String)config.get(LOOKUP_CACHE_RELOAD_TIME_BLACKLIST)), (Integer)config.get(LOOKUP_CACHE_SCAN_LIMIT));
        }
        if (cacheType == CacheStrategy.ALL) {
            return new CacheConfig(com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy.all(((Duration)config.get(LOOKUP_CACHE_TTL)).toMillis()));
        }
        return new CacheConfig(com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy.none());
    }

    public static String[] parseMysqlJdbcUrl(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String[] result = new String[]{matcher.group("hostname"), matcher.group("port"), matcher.group("dbName")};
            return result;
        }
        throw new ValidationException(String.format("The hostname, port and database name can not be parsed from url '%s' rightly.", url));
    }
}

